#include "MapEditor.h"

// ꍇɂĂ͎gȂϐ̂ŁEEEE
#pragma warning(disable : 4101)

void GameMain(){
	ysFrame.SetAppName("MapEditor");
	ysFrame.SetNextScene(MapEditor);
	ysDraw.SetDisplayMode(FullScreenMode,640,480,8);
	return;
}

SCENE_DEFINE(MapEditor){
	static CPlane		*Select;
	static CPlane		*MyPlane;
	static CMapLayer2	*MyMap;
	static CYFile		*MyFile;

	static WORD			Chip;
	static BYTE			x, y;
	static BYTE			MapWidth, MapHeight;

	int OldX, OldY;

	SCENE_CONSTRUCTOR{
		BYTE xx,yy,cx[3],cy[3];
		// I͈
		Select = new CPlane;
		Select->LoadBitmapFile("Select.bmp",false);
		Select->SetColorKey(0,0);
		// }bvoN
		MyPlane = new CPlane;
		MyPlane->LoadBitmapFile(MapBank,true);
		MyPlane->SetColorKey(0,0);
		// }bvC
		MyMap = new CMapLayer2;
		MyMap->SetMapBank(MyPlane);
		MyMap->SetMapChipSize(32,32);
		MyMap->Move(-304,-224);
		// t@C
		MyFile = new CYFile;
		if (ExistFile){
			MyFile->ReadFile(MapFile);
			MyFile->ReadData(&MapWidth, 1);
			MyFile->ReadData(&MapHeight, 1);
			MyMap->SetMapSize(MapWidth,MapHeight);
			for (xx=0;xx<NewWidth;xx++)
				for (yy=0;yy<NewHeight;yy++){
					MyFile->ReadData(cx,3);
					MyFile->ReadData(cy,3);
					if (xx<MapWidth&&yy<MapHeight){
						if (cy[0]!=255) MyMap->GetMapChip(xx,yy)->chip1a=cy[0]*256+cx[0];
						if (cy[1]!=255) MyMap->GetMapChip(xx,yy)->chip2a=cy[1]*256+cx[1];
						if (cy[2]!=255) MyMap->GetMapChip(xx,yy)->chip3a=cy[2]*256+cx[2];
					}
				}
			MyFile->ReleaseFileBuffer();
			if (NewWidth!=MapWidth||NewHeight!=MapHeight){
				MyMap->ResizeMap(NewWidth,NewHeight);
				MapWidth = NewWidth;
				MapHeight = NewHeight;
			}
		}else{
			MyMap->SetMapSize(NewWidth,NewHeight);
			for (xx=0;xx<NewWidth;xx++)
				for (yy=0;yy<NewHeight;yy++){
					MyMap->GetMapChip(xx,yy)->chip1a=DefaultY*256+DefaultX;
				}
			MapWidth = NewWidth;
			MapHeight = NewHeight;
		}
		// ̑낢
		ysDraw.RealizePalette(*MyPlane);
		Chip=x=y=0;
	}
	SCENE_DESTRUCTOR{
		BYTE MapData[NewWidth*NewHeight*6+2];
		BYTE xx,yy;
		DWORD cn;
		CMapChip *MyChip;
		// Z[u
		MapData[0]=NewWidth;
		MapData[1]=NewHeight;
		for (xx=0;xx<NewWidth;xx++)
			for (yy=0;yy<NewHeight;yy++){
				cn=(xx*NewWidth+yy)*6+2;
				MyChip = MyMap->GetMapChip(xx,yy);
				if (MyChip->chip1a>=0) MapData[cn] = MyChip->chip1a % 256; else MapData[cn] = 255;
				if (MyChip->chip2a>=0) MapData[cn+1] = MyChip->chip2a % 256; else MapData[cn+1] = 255;
				if (MyChip->chip3a>=0) MapData[cn+2] = MyChip->chip3a % 256; else MapData[cn+2] = 255;
				if (MyChip->chip1a>=0) MapData[cn+3] = MyChip->chip1a / 256; else MapData[cn+3] = 255;
				if (MyChip->chip2a>=0) MapData[cn+4] = MyChip->chip2a / 256; else MapData[cn+4] = 255;
				if (MyChip->chip3a>=0) MapData[cn+5] = MyChip->chip3a / 256; else MapData[cn+5] = 255;
			}
		MyFile->WriteFile(MapFile,MapData,sizeof(MapData));
		delete MyFile;
		delete MyMap;
		delete MyPlane;
	}
	SCENE_INITIALIZER;
	OldX=x; OldY=y;
	ysDraw.ClearSecondary();
	KEY_INPUT;
	if (KEYPRESS(DIK_LSHIFT)||KEYPRESS(DIK_RSHIFT)){
		if (KEY_8) Chip-=256;
		if (KEY_2) Chip+=256;
		if (KEY_4) Chip-=1;
		if (KEY_6) Chip+=1;
		MyMap->OnPaint();
		MyPlane->BltFast(16,16);
		Select->Blt(16+Chip%256*32,16+Chip/256*32);
	}else{
		if (y>=1&&KEY_8) y-=1;
		if (y<MapHeight-1&&KEY_2) y+=1;
		if (x>=1&&KEY_4) x-=1;
		if (x<MapWidth-1&&KEY_6) x+=1;
		if (KEYPRESS(DIK_1)) MyMap->GetMapChip(x,y)->chip1a=Chip;
		if (KEYPRESS(DIK_2)) MyMap->GetMapChip(x,y)->chip2a=Chip;
		if (KEYPRESS(DIK_3)) MyMap->GetMapChip(x,y)->chip3a=Chip;
		if (OldX!=x||OldY!=y) MyMap->Move(x*32-304,y*32-224);
		MyMap->OnPaint();
		Select->Blt(304,224);
	}
	if (KEY_ESC) ysFrame.Quit();
}