#include "yaneDir.h"
#include "yaneMacro.h"

//////////////////////////////////////////////////////////////////////////////
//	<yanepackp\̂ɂ>
//		t@Cwb_[ "yanepack" 8oCg + i[t@C DWORD
//		̌AȉCFileInfoi[t@CāAƂ̓f[^
class CFileInfo {
public:
	char	filename[32];
	DWORD	startpos;	//	seek pos
	size_t	filesize;	//	file size
};
//////////////////////////////////////////////////////////////////////////////

CYDir::CYDir(void) {
	m_handle	=	INVALID_HANDLE_VALUE;
	m_hPackFile =	INVALID_HANDLE_VALUE;
	m_cydir		=	NULL;
	m_file		=	"*.*";

	m_bSubDir	= true;
	m_bPackFile	= true;
	m_bAllFile	= false;
}

CYDir::~CYDir()	{ CloseFindFile(); }

//////////////////////////////////////////////////////////////////////////////

void CYDir::SetFindFile(const string& file){
	CloseFindFile();	//	˂
	m_file = file;
}

void CYDir::SetPath(const string& file){
	m_path = file;
	string::iterator p = m_path.end()-1;
	if (*p=='/' || *p=='\\') m_path.erase(p);
}

void CYDir::CloseFindFile(void) {
	if(m_handle!=INVALID_HANDLE_VALUE) {
		FindClose(m_handle);
		m_handle=INVALID_HANDLE_VALUE;
	}
	if(m_hPackFile!=INVALID_HANDLE_VALUE) {
		CloseHandle(m_hPackFile);
		m_hPackFile=INVALID_HANDLE_VALUE;
	}
	DELETE_SAFE(m_cydir);
}

//////////////////////////////////////////////////////////////////////////////

bool	CYDir::IsFileExist(const string& file){		//	̃t@C݂͑̂H
	HANDLE h;
	h  = CreateFile(file.c_str(),
					GENERIC_READ,		// Read
					FILE_SHARE_READ,	// ReadOpenȂ狤L̂̓}i[ 
					NULL,				// security
					OPEN_EXISTING,		// ݂ĂȂ΃G[
					FILE_ATTRIBUTE_NORMAL,	//	t@C
					NULL				// ev[gt@C
					);
	if (h==INVALID_HANDLE_VALUE) return false;
	CloseHandle(h);
	return true;
}

//////////////////////////////////////////////////////////////////////////////
LRESULT CYDir::FindFile(string &file){
	int result;
	WIN32_FIND_DATA FindFileData;
	DWORD NumberOfBytesRead;		// dummy

retry:;
	//	sub folderLȂ΍ċAIɌ
	if (m_cydir!=NULL) {
		if (m_cydir->FindFile(file)==0) {
			return 0;
		}
		DELETE_SAFE(m_cydir);
	}
	if (m_hPackFile!=INVALID_HANDLE_VALUE) {
		while (m_dwFileNum--!=0){
			CFileInfo info;
			if (!::ReadFile(m_hPackFile,&info,sizeof(info),&NumberOfBytesRead,NULL)){
				CloseHandle(m_hPackFile);
				m_hPackFile=INVALID_HANDLE_VALUE;
				goto retry;
			}
			file = info.filename;	//	ĂeXg
			if (IsMatch(file.c_str(),m_file.c_str())) {
				//	vI
				file = m_PackName + file;
				//	kt@CȊÔƂɑ݂΁A͋p:p
				//	idăXgAbvĂ܂߁j
				if (!IsFileExist(file)) return 0;
			}
		}
		CloseHandle(m_hPackFile);
		m_hPackFile=INVALID_HANDLE_VALUE;
	}

	//	VKȂ̂H
	if (m_handle==INVALID_HANDLE_VALUE) {
		m_handle = FindFirstFile((m_path+"\\*.*").c_str(),&FindFileData);
		if (m_handle == INVALID_HANDLE_VALUE) result=1; else result=0;
	} else {
		if (FindNextFile(m_handle,&FindFileData)!=0) result=0; else result=1;
	}

	if (result==0) {
		file = FindFileData.cFileName;
		if (!m_bAllFile && (FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)) {
			if (file == "." || file == "..") goto retry; // ȂEȂ...
			if (m_bSubDir) {	// subtH_͌ΏۂH
				m_cydir = new CYDir;
				m_cydir->EnableSubdir(m_bSubDir);		// must be true
				m_cydir->EnablePackFile(m_bPackFile);
				m_cydir->SetFindFile(m_file);
				m_cydir->SetPath(m_path+"\\"+file);
			}
			goto retry;
		} else {
			//	kt@Cpi߂ǂȂcj
			if (m_bPackFile && m_bSubDir && IsMatch(file.c_str(),"*.dat")){
				//	kt@CΏۂȂ񂩁H
				m_hPackFile = CreateFile((m_path+"\\"+file).c_str(),
				GENERIC_READ,		// Read
				FILE_SHARE_READ,	// ReadOpenȂ狤L̂̓}i[ 
				NULL,				// security
				OPEN_EXISTING,		// ݂ĂȂ΃G[
				FILE_ATTRIBUTE_NORMAL,	//	t@C
				NULL				// ev[gt@C
				);
			}
			if (m_hPackFile == INVALID_HANDLE_VALUE) goto check;
			char ident[9];
			ident[8] = '\0';
			if (!::ReadFile(m_hPackFile,ident,8,&NumberOfBytesRead,NULL) || strcmp(ident,"yanepack")){
				CloseHandle(m_hPackFile);
				m_hPackFile = INVALID_HANDLE_VALUE;
				goto check;
			}
			if (!::ReadFile(m_hPackFile,&m_dwFileNum,sizeof(m_dwFileNum),&NumberOfBytesRead,NULL)){
				CloseHandle(m_hPackFile);
				m_hPackFile = INVALID_HANDLE_VALUE;
				goto check;
			}
			//	.dat؂藎ƂătH_ɕϊ
			string::size_type pos1;
			pos1 = file.rfind('.');
			file.erase(pos1);
			m_PackName = m_path + "\\" + file + "\\";
			goto retry;	//	kt@CT

check:;
			//	vIH
			if (IsMatch(file.c_str(),m_file.c_str())) {
				//	pack fileȂΊOKv...!?
				file = m_path + "\\" + file;	//	tpXŕԂ
				m_bDir = (FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) !=0;
				result = 0;
			} else {
				goto retry;
			}

		}
	} else {
		CloseFindFile();
	}

	return result;
}

//////////////////////////////////////////////////////////////////////////////

//	Check two strings match,using wildcard('*'or'?'). 
//	This algorithm is examine recursively.(C) yaneurao 1999
bool CYDir::IsMatch(LPCSTR it1,LPCSTR it2){
//	it1it2ƃ}b`邩
//	it1ɂ́A'*''.'gpł

	//	܂͊قĂ
	while (true){
		if (*it1 == '*') {
			it1++;
			do {
				if (IsMatch(it1,it2)) return true;	//	łvtrue
			} while (*(it2++)!='\0'); 
			return false;	//	ׂĈvȂȂfalse
		}
		if (*it2 == '*') {
			it2++;
			do {
				if (IsMatch(it1,it2)) return true;	//	łvtrue
			} while (*(it1++)!='\0'); 
			return false;	//	ׂĈvȂȂfalse
		}
		if ((toupper(*it1) != toupper(*it2)) && (*it1 != '?') && (*it2 != '?')) return false;		// _
		if (*it1=='\0' && *it2=='\0') return true;	//	v
		if (*it2=='\0' || *it2=='\0') return false;
		it1 ++;
		it2 ++;
	}
}

//////////////////////////////////////////////////////////////////////////////
