// yaneDir.h :
//
//		directory file wrapper
//
//			programmed by yaneurao(M.Isozaki) '99/10/19 - '99/11/28
//

#ifndef __yaneDir_h__
#define __yaneDir_h__

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include <string>				//	STL
using namespace std;

class CYDir {
public:
	//	Directory
	void	SetFindFile(const string& file);					//	t@Cݒ
	void	SetPath(const string& file);						//	pXݒ
	void	EnableSubdir(bool b) { m_bSubDir = b; }				//	̂ƂɃTutH_Lɂ̂
	void	EnablePackFile(bool b) { m_bPackFile = b; }			//	yanePackt@CΏۂɂ̂H

	LRESULT	FindFile(string& file);								//	t@C擾(ԂlOȂNot Found)
	static bool IsMatch(LPCSTR it1,LPCSTR it2);					//	̕񂪈v邩H(wildcardgp\)

	void	EnableDirListup(bool b) { m_bAllFile = b; }			//	tH_}b`OΏۂɂ
	bool	IsDir(void) { return m_bDir; }						//	FindFileŎ擾̂̓tH_H

	bool	IsFileExist(const string& file);					//	̃t@C݂͑̂H

	//	Drives
	DWORD	CheckDrive(void) { return m_dwDrive=::GetLogicalDrives(); }
	bool	IsExistDrive(int n) { return (m_dwDrive & (1L << n))!=0; }
public:
	CYDir(void);
	~CYDir();
protected:
	void	CloseFindFile(void);								//	I
	string	m_file;			//	t@C
	string	m_path;			//	path
	HANDLE	m_handle;		//	nh
	bool	m_bSubDir;		//	subdirLH	
	bool	m_bPackFile;	//	packfileLH	
	CYDir	*m_cydir;		//	subdirp(ċAIɗp)

	//	tH_̃XgAbvp
	bool	m_bAllFile;		//	tH_Ώۂɂ̂H
	bool	m_bDir;			//	܎擾̂̓tH_H

	//	kt@Cp
	HANDLE	m_hPackFile;	//	kt@Cpnh
	DWORD	m_dwFileNum;	//	kt@Ct@C
	string	m_PackName;		//	̈kt@C
protected:
	DWORD	m_dwDrive;
};

#endif
