// DirectDraw Wrapper
//

#include <string.h>			// strlen

#include "yaneDirectDraw.h"
#include "yaneFile.h"		// for LoadPlane
#include "yaneCOM.h"		// COM̗p̂
#include "yaneMacro.h"
#include "yaneError.h"

//////////////////////////////////////////////////////////////////////////////

LPDIRECTDRAW CDirectDraw::m_lpDirectDraw=NULL;	// C^[tF[X
LPDIRECTDRAWSURFACE CDirectDraw::m_lpSecondary;	// obNobt@
LPDIRECTDRAWCLIPPER CDirectDraw::m_lpClipper;	// Nbp[
int	CDirectDraw::m_nScreenXSize;				// ʃTCY
int	CDirectDraw::m_nScreenYSize;				//

//////////////////////////////////////////////////////////////////////////////

CDirectDraw::CDirectDraw(void){
	
	m_lpDirectDraw	= NULL;
	m_lpPrimary		= NULL;
	m_lpPaletteMain = NULL;
	m_lpSecondary	= NULL;
	m_lpClipper		= NULL;

	m_ScreenMode	= WindowMode;
	m_nScreenXSize	= 640;
	m_nScreenYSize	= 480;
	m_nScreenColorMode = 0; // wȂ

	m_bBrightnessChanged = false;
	m_nBrightness = 256; // l͓R256
	m_lpAttachedPalettePlane = NULL;

	m_bUseDirectDrawFlip = true;
	m_bUseDirectDrawFlip2 = false; // Ȃ̏Î߈ꉞ

	m_bDisplayChanging = false;
	m_bUseSystemMemory = false; // falseĂ΁I
	m_bUseGDIBlt = false;
	m_bNowShowCursor = true;	// }EXJ[\͏Ԃŕ`
	m_hIME = NULL;	// IMEۑp

	m_BackupPlane = NULL;		//	obNAbvv[
	m_bBackup = false;

	m_nSecondaryOffsetX = m_nSecondaryOffsetY = 0;

    if (CYCOM::AddRef()) { // COMgŁ[
		m_bSucessInit = false;
	} else {
		m_bSucessInit = true;
	}
}

CDirectDraw::~CDirectDraw(){
	DELETE_SAFE(m_BackupPlane);
	// Terminate(); // sȎ҂̂߂ɈꉞAI:p
	ShowCursor(true); // Ȃ񂵂܂܂ƁAsK:p
	RELEASE_SAFE(m_lpDirectDraw);
	CYCOM::Release(); // COMgIŁ[
}

//////////////////////////////////////////////////////////////////////////////
//	܂ǂ݌vł͂Ȃc
HWND	CDirectDraw::CreateDrawWindow(HINSTANCE hInst,string appName){
	return m_GameWindow.InitWindow(hInst,appName,m_ScreenMode,m_nScreenXSize,m_nScreenYSize);
}
//////////////////////////////////////////////////////////////////////////////

LRESULT CDirectDraw::Initialize(HWND hWnd,HINSTANCE hInst){ // 
	m_hWnd = hWnd;	// ƂƎg...

//	Terminate();	// ꉞA|C^̉

	// m_lpPlanéA{̓|C^ɂȂ̂ADirectDrawIuWFNgO
	// fXgNĝŁAȂɃ|C^ɂB

	// COMIďo
	if (CoCreateInstance(CLSID_DirectDraw,
			NULL, CLSCTX_ALL, IID_IDirectDraw, (LPVOID*)&m_lpDirectDraw)!=DD_OK){
		InnerLog("CDirectDraw::InitializeCoCreateInstanceɎs");
		return 1;
	}
	m_lpDirectDraw->Initialize(NULL);

	// fBXvC[h̕ύXƃT[tF[XEpbg̍쐬
	if (ChangeDisplayMode()) return 1;

	MsgHook(hWnd); // WindowMessageHook
	
	// DirectDraw̔wihԂF̐ݒ
	SetFillColor(m_GameWindow.GetFillColor());
	
	return 0;
}

LRESULT CDirectDraw::Terminate(void){

	MsgUnhook(); // WindowMessageUnhook

	CPlane::ReleaseBufferAll();	// ReleaseƂƂ:p
	
	if (m_ScreenMode!=FullScreenMode || !m_bUseDirectDrawFlip2) {
	// FullScreenModeFlippɃA^b`ĂAKvȂB
		RELEASE_SAFE(m_lpSecondary);
	} else {
		m_lpSecondary = NULL;
	}

	RELEASE_SAFE(m_lpClipper);

	// pbg̃f^b`iA^b`ĂPalettẻj
	if (m_lpPrimary!=NULL && m_lpPrimary->SetPalette(NULL)!=DD_OK){
		if(m_lpPrimary->IsLost()){
			m_lpPrimary->Restore();
			m_lpPrimary->SetPalette(NULL);
		}
	}
	RELEASE_SAFE(m_lpPrimary);
	RELEASE_SAFE(m_lpPaletteMain);

	if(m_lpDirectDraw != NULL) { // fBXvC[h̕
		if (m_lpDirectDraw->SetCooperativeLevel(NULL,DDSCL_NORMAL)!=DD_OK) {
			InnerLog("DDraw:ISetCooperativeLevelɎs");
			// ŎsHHI
		}
		if (m_lpDirectDraw->RestoreDisplayMode()){
			InnerLog("DDraw:IŃfBXv[[hAs..");
		}
	}
	RELEASE_SAFE(m_lpDirectDraw);

	return 0;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CDirectDraw::InstallPalette(void){

	PALETTEENTRY pal[256];

	// tXN[[hł̓VXepbg̕ی
	if (m_ScreenMode==FullScreenMode) {
		HDC hdc = GetDC(m_hWnd);
		if (hdc!=NULL) {
			SetSystemPaletteUse(hdc,SYSPAL_STATIC);
			GetSystemPaletteEntries(hdc,0,256,pal);
			ReleaseDC(m_hWnd,hdc);
			// GetSystemPaletteEntriesł͂ȂƁA0`19Ƀpbg
			// āA10́AŌɈړȂĂ͂ȂȂII
			CopyMemory(&pal[246],&pal[10],sizeof(PALETTEENTRY)*10);
		}
	} else {
	  // ݒ肵ĂtXN[[hł͖...
	  for(int i=0;i<10;i++){
		pal[i].peFlags = PC_EXPLICIT; // ̃IvVƂƂɁA
		pal[i].peRed	= i; // VXepbgCfbNXw肷
		pal[i].peGreen	= 0;
		pal[i].peBlue	= 0;

		// 0`9,246`255̐F̑␫l΁AZł͂ȂxorقS
		pal[i ^ 0xff].peFlags = PC_EXPLICIT;
		pal[i ^ 0xff].peRed	   = i ^ 0xff;
		pal[i ^ 0xff].peGreen  = 0;
		pal[i ^ 0xff].peBlue   = 0;
	  }
	}

	// [U[pbg̐ݒ
	for(int i=10;i<246;i++) {
		pal[i].peFlags = PC_NOCOLLAPSE | PC_RESERVED;
		// ̃AvɎgĂ͍邵AύXĂ
		
		// Default Palette̓I(c) yaneurao.
		int j;
		j = i-10; if(j>128) j=0;
		pal[i].peRed   = (BYTE)(((j >> 4) & 0x07) * 255 / 7); // 3 bits
		pal[i].peGreen = (BYTE)(((j >> 2) & 0x03) * 255 / 3); // 2 bits
		pal[i].peBlue  = (BYTE)(((j >> 0) & 0x03) * 255 / 3); // 2 bit
	}

	if (m_lpPaletteMain !=NULL) {
		InnerLog("ȂCDirectDraw::InstallPalettem_lpPaletteMain!=NULL?");
		RELEASE_SAFE(m_lpPaletteMain);
	}

	// xCreatePalettê͗ǂȂB
	if (m_lpDirectDraw->CreatePalette(DDPCAPS_8BIT,pal,&m_lpPaletteMain,NULL)!=DD_OK){
		InnerLog("DirectDrawInitŁACreatePaletteɎs");
		m_lpPaletteMain = NULL;
		return 0; // 256F[hȊOłpbĝ͍쐬łB
	}

	if (m_lpPrimary->SetPalette(m_lpPaletteMain)== DDERR_SURFACELOST) {
		m_lpPrimary->Restore(); // ̃G[`FbN...ł傤...
		if (m_lpPrimary->SetPalette(m_lpPaletteMain)!=DD_OK){
			InnerLog("DirectDrawInitSetPaletteɎs");
			return 1;
		}
	}

	//	m_lpSecondaryɂSetPaletteĂقǂmȂ...

	return 0;
}

//////////////////////////////////////////////////////////////////////////////

void CDirectDraw::BeginChangeDisplay(void){
	m_bDisplayChanging = true;

	CPlane::ReleaseBufferAll();
	// ǂݍłt@C͎c

	if (m_ScreenMode!=FullScreenMode || !m_bUseDirectDrawFlip2) {
	// FullScreenModeFlippɃA^b`ĂAKvȂB
		RELEASE_SAFE(m_lpSecondary);
	} else {
		m_lpSecondary = NULL;
	}

	// pbg̃f^b`iA^b`ĂPalettẻj
	if (m_lpPrimary!=NULL && m_lpPrimary->SetPalette(NULL)== DDERR_SURFACELOST ) {
		m_lpPrimary->Restore(); // ̃G[`FbN...ł傤...
		m_lpPrimary->SetPalette(NULL);
	}
	
	RELEASE_SAFE(m_lpClipper);
	RELEASE_SAFE(m_lpPrimary);
	RELEASE_SAFE(m_lpPaletteMain);

	if(m_lpDirectDraw != NULL) { // fBXvC[h̕
		if (m_ScreenMode==WindowMode) {
			if (m_lpDirectDraw->SetCooperativeLevel(NULL,DDSCL_NORMAL)!=DD_OK){
				InnerLog("ChangeDisplayModeSetCooperativeLevelɎs..");
			}
			// EBhD[hɂƂ́AsȂKv
			if (m_lpDirectDraw->RestoreDisplayMode()){
				InnerLog("ChangeDisplayModeRestoreDisplayModeɎs..");
			}
		}
	}

}

void CDirectDraw::TestDisplayMode(EScreenMode scrmode,int nSX,int nSY,int nColor){
	if (!m_bDisplayChanging) return ; // already changing!!

	// DirectDrawObject͗L̂H
	if (m_lpDirectDraw==NULL) return ;

	switch (scrmode) {
	case WindowMode :
		// Window[h̎w肪ȂΎdȂB
		if (m_lpDirectDraw->SetCooperativeLevel(m_hWnd,DDSCL_NORMAL)!=DD_OK){
			InnerLog("DirectDrawSetCooperativeLevelDDSC_NORMALŎs");
			return ; // ł񂩂͂茾ăVȂ̂₯...
		}
		break;
	case FullScreenMode :
		if (m_lpDirectDraw->SetCooperativeLevel(m_hWnd,
				DDSCL_EXCLUSIVE|DDSCL_FULLSCREEN)!=DD_OK){
			InnerLog("DirectDrawSetCooperativeLevelDDSC_EXCLUSIVEŎs");
			return ; // ̃AvgĂ񂿂ႤH
		}
		if (m_lpDirectDraw->SetDisplayMode(nSX,nSY,nColor)!=DD_OK){
			InnerLog("DirectDrawSetDisplayModeɎs");
			return ; // ΉH
		}
		break;
	}

	m_bUseDirectDrawFlip2 = m_bUseDirectDrawFlip;
	if (scrmode != FullScreenMode ) m_bUseDirectDrawFlip2 = false;

sur_retry: ;
	DDSURFACEDESC ddsd;
	ZERO(ddsd);
	ddsd.dwSize = sizeof(ddsd);

	if (m_bUseDirectDrawFlip2) {
		ddsd.dwFlags = DDSD_CAPS | DDSD_BACKBUFFERCOUNT;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE
			| DDSCAPS_FLIP
			| DDSCAPS_COMPLEX;
		ddsd.dwBackBufferCount = 1;
	} else {
		ddsd.dwFlags = DDSD_CAPS;
		ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
	}

	if (m_lpDirectDraw->CreateSurface(&ddsd,&m_lpPrimary,NULL)!=DD_OK){
		InnerLog("DirectDrawCreateSurfaceɎs");
		if (m_bUseDirectDrawFlip2) {
			m_bUseDirectDrawFlip2=false;
			// Flipping Surface̓rfIɔzuKv邽߁A
			// CreateɃ~XƂl
			goto sur_retry;
		}
		return ; // [
	}

	// EBhD[hłȂ΁ANbpZbgB
	if (scrmode == WindowMode){
		if (m_lpDirectDraw->CreateClipper(0,&m_lpClipper,NULL)!=DD_OK){
			InnerLog("DirectDrawClipper\zs");
			return ;
		}
		if (m_lpClipper->SetHWnd(0,m_hWnd)!=DD_OK){
			InnerLog("DirectDrawClipperhWNDZbgłȂ");
			return ;
		}
		if (m_lpPrimary->SetClipper(m_lpClipper)!=DD_OK){
			InnerLog("DirectDrawSetClipperɎs");
			return ;
		}
	}

sur_retry2: ;
	if (m_bUseDirectDrawFlip2) {
		// flipgȏAVXeɃobt@mۂ̂͂܂DDD
		DDSCAPS ddscaps;		
		if (m_bUseSystemMemory) {
			ddscaps.dwCaps = DDSCAPS_BACKBUFFER | DDSCAPS_SYSTEMMEMORY;
		} else {
			ddscaps.dwCaps = DDSCAPS_BACKBUFFER;
		}
		if (m_lpPrimary->GetAttachedSurface(&ddscaps,&m_lpSecondary)!=DD_OK){
			InnerLog("DirectDrawGetAttachedSurfaceɎs");
			// ق₩猾񂱂ȂI
			m_bUseDirectDrawFlip2 = false;
			goto sur_retry2;
		}
	} else {
		ZERO(ddsd);
		ddsd.dwSize = sizeof(ddsd);
		ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
		if (m_bUseSystemMemory) {		
			ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN | DDSCAPS_SYSTEMMEMORY;
		} else {
			ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
		}
		ddsd.dwWidth  = m_nScreenXSize;
		ddsd.dwHeight = m_nScreenYSize;
		if (m_lpDirectDraw->CreateSurface(&ddsd,&m_lpSecondary,NULL)!=DD_OK){
			InnerLog("DirectDrawCreateSurfaceɎs");
			return ; // [
		}
	}

	ClearSecondary(); // ꉞANAˁI

	// -----------------------------------------------------------------------
	// ܂ŗȂAЂƂ܂fBXvC[h̕ύX͐ƌ

	m_ScreenMode		= scrmode;
	m_nScreenXSize		= nSX;
	m_nScreenYSize		= nSY;
	m_nScreenColorMode2 = CPlane::GetBpp();	// ύX

	m_bDisplayChanging	= false; // ʃ[h̕ύXɐI

	// -----------------------------------------------------------------------

	// 256łȂȂ΃pbg̐ݒ͖Ӗ
	if (m_nScreenColorMode2==8) InstallPalette();

	return ;
}

LRESULT CDirectDraw::EndChangeDisplay(void){
	if (m_bDisplayChanging) { // ChangeĂȂII
		InnerLog("BeginChangeDisplay`EndChangeDisplayɎs");
		return 1;
	}

	// v[̍č\ziĂ΁j

	// FlushPalette();	// pbgACYĂI
	CPlane::RestoreAll();

	// pbg̍č\z
	m_bBrightnessChanged = true;

	// Oŕ`悷ȂΊ֌WȂ̂...
	// }EXJ[\̐ݒ
	if (m_ScreenMode == FullScreenMode) {
		ShowCursor(false); // tXN[Ȃ΃J[\͔\
	} else {
		ShowCursor(true);
	}
	
	// EBhDX^C̕ύX
	if (m_ScreenMode == WindowMode) {
		RECT r;
		r.left	 = (GetSystemMetrics(SM_CXSCREEN)-m_nScreenXSize) >> 1;
		r.top	 = (GetSystemMetrics(SM_CYSCREEN)-m_nScreenYSize) >> 1;
		r.right	 = r.left + m_nScreenXSize;
		r.bottom = r.top  + m_nScreenYSize;

		LONG style = m_GameWindow.GetWindowStyle();
		
		AdjustWindowRect(&r,style,false);
		SetWindowPos(m_hWnd,NULL,
			r.left,r.top,r.right-r.left,r.bottom-r.top,
			SWP_NOZORDER|SWP_NOMOVE); // SWP_NOMOVE͂ǂȁ`
		SetWindowLong(m_hWnd,GWL_STYLE,style);
		SetMenu(m_hWnd,GetMenu(m_hWnd)); // j[̈̍ĕ`
		ShowWindow(m_hWnd,SW_SHOW);
		if (m_hIME!=NULL) {
			ImmAssociateContext(m_hWnd,m_hIME); // IME On
		}
	} else {
		SetWindowLong(m_hWnd, GWL_STYLE, WS_POPUP);
//		SetWindowLong(m_hWnd, GWL_EXSTYLE, WS_EX_TOPMOST);
		ShowWindow(m_hWnd,SW_SHOW);
		if (m_hIME==NULL) {
			m_hIME=ImmAssociateContext(m_hWnd,NULL); // IME Off
		}
	}

	return 0;
}

/////// gp:p) ////////////////////////////////////////////////////////////

LRESULT CDirectDraw::ChangeDisplayMode(void){
	BeginChangeDisplay();
		if (m_ScreenMode == FullScreenMode) {
			TestDisplayMode(FullScreenMode,m_nScreenXSize,m_nScreenYSize
				,m_nScreenColorMode);
		}
		TestDisplayMode(WindowMode,m_nScreenXSize,m_nScreenYSize,0);
	if (EndChangeDisplay()) return 1;
	return 0;
}
//////////////////////////////////////////////////////////////////////////////

void	CDirectDraw::SetDirectDrawFlipUse(bool b){
	m_bUseDirectDrawFlip = b;
}

bool	CDirectDraw::GetDirectDrawFlipUse(void){	// 擾
	return m_bUseDirectDrawFlip2;
}

// ---------------------------------------------------------------------------

LRESULT CDirectDraw::CheckSurfaceLost(void){
	if ((m_lpPrimary!=NULL && m_lpPrimary->IsLost() == DDERR_SURFACELOST) ||
		(m_lpSecondary!=NULL && m_lpSecondary->IsLost() == DDERR_SURFACELOST)) {
		// LOSTĂȂ̂RestoreA܂obt@B}WŁi΁j
		
		if (m_lpPrimary!=NULL && m_lpPrimary ->Restore()!=DD_OK) {
//			InnerLog("RestoreSurface lpPrimaryLostĂ܂[");
			return ChangeDisplayMode();
		}
		if (m_lpPrimary!=NULL && m_lpSecondary ->Restore()!=DD_OK) {
			InnerLog("RestoreSurface lpSecondaryLostĂ܂[");
			// Ȃ...
			return ChangeDisplayMode();
		}
		// ЂƂāÂ݂LOSTĂ񂿂ႤȁH
		CPlane::RestoreAll();
	}

	return 0;
}

// ---------------------------------------------------------------------------
void CDirectDraw::RealizeBrightness(int brightness,bool bAfterDraw){
  // DrawFlipɂ閾邳̕ύX
  if (bAfterDraw && (m_nScreenColorMode2==8)) {
	if (m_lpPaletteMain==NULL) return ;
	// 256F`̃pbg
	if (m_bBrightnessChanged) {
		m_bBrightnessChanged = false;
		
		m_lpAttachedPalettePlane = CPlane::m_lpPalettePlaneNow; // ꉞύX˂
		if (m_lpAttachedPalettePlane==NULL) return ; //@ݒ肳ĂȂ
		
		LPDIRECTDRAWPALETTE dp;
		if ((dp=m_lpAttachedPalettePlane->GetPalette())==NULL) return ;

		PALETTEENTRY pal[236]; // 236FQbg
		if ((dp->GetEntries(0,10,236,pal))==DD_OK){
			// ̏d悤...
			for(int i=0;i<236;i++) {
				pal[i].peBlue  = (BYTE)(m_nBrightness * pal[i].peBlue  >> 8);
				pal[i].peRed   = (BYTE)(m_nBrightness * pal[i].peRed   >> 8);
				pal[i].peGreen = (BYTE)(m_nBrightness * pal[i].peGreen >> 8);
			//	GetEntrieśApeFlagRs[ȂBȂ񂿂[dl
			//	ApeFlag == 0ɂ邱ƂŁA}bvhƂo悤
			}
			m_lpPaletteMain->SetEntries(0,10,236,pal);
			return ;
		}
		return ;
	}
	if (m_lpAttachedPalettePlane != CPlane::m_lpPalettePlaneNow) {
		m_lpAttachedPalettePlane = CPlane::m_lpPalettePlaneNow;
		if (m_lpAttachedPalettePlane==NULL) return ;
		
		LPDIRECTDRAWPALETTE dp;
		if ((dp=m_lpAttachedPalettePlane->GetPalette())==NULL) return ;
		
		PALETTEENTRY pal[236]; // 236FQbg
		if ((dp->GetEntries(0,10,236,pal))==DD_OK){
			m_lpPaletteMain->SetEntries(0,10,236,pal);	  // ʂȂ悤\tgIɕύX
		}
		return ;
	}
	return ;
  }

  if (!bAfterDraw && (m_nScreenColorMode2!=8)) {
	if (m_nBrightness==256) return ;

	  // F[hȂ̂ŃZJ_𒼐ڏ
	  // T[tF[X̒IiӋZ:pj
	  DDSURFACEDESC dddesc;
	  ZERO(dddesc); // ꉞ
	  dddesc.dwSize = sizeof(dddesc);
	  if (m_lpSecondary->Lock(NULL,&dddesc,
			DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL)!=DD_OK){
			InnerLog("RealizeBrightnessSurfaceLockɎs");
			return ;
	  }

	  LONG lPitch  = dddesc.lPitch;

	  // sNZtH[}bgQƂȂ
	  // Ƃ65536F\ł32rbggpĂ\
	  switch (dddesc.ddpfPixelFormat.dwRGBBitCount) {
	  case 16: { // 65536F[h
	  // DWORD܂Ƃ߂Ėʓ|I
		DWORD RMask, GMask, BMask;
		DWORD RMask2, GMask2, BMask2;

		RMask = dddesc.ddpfPixelFormat.dwRBitMask;
		GMask = dddesc.ddpfPixelFormat.dwGBitMask;
		BMask = dddesc.ddpfPixelFormat.dwBBitMask;
		RMask2 = dddesc.ddpfPixelFormat.dwRBitMask <<16;
		GMask2 = dddesc.ddpfPixelFormat.dwGBitMask <<16;
		BMask2 = dddesc.ddpfPixelFormat.dwBBitMask <<16;

		DWORD *p = (DWORD*)dddesc.lpSurface;
		
		for(int y=0;y<m_nScreenYSize;y++){
			for (int x=0; x<(m_nScreenXSize>>1);x++) {
				DWORD pixel, px;
				px	= p[x];
				pixel  = ((DWORD)(((px&RMask )*brightness)>>8)&RMask);
				pixel |= ((DWORD)(((px&GMask )*brightness)>>8)&GMask);
				pixel |= ((DWORD)(((px&BMask )*brightness)>>8)&BMask);
				pixel |= ((DWORD)(((px&RMask2)>>8)*brightness)&RMask2);
				pixel |= ((DWORD)(((px&GMask2)>>8)*brightness)&GMask2);
				pixel |= ((DWORD)(((px&BMask2)>>8)*brightness)&BMask2);
				p[x] = pixel;
			}
			p = (DWORD*)((BYTE*)p + lPitch); // PX^̑
			// BYTEɃLXgĂȂƌvZԈႤ:p
		}
	  } break;

	  case 24: {
	  // łBm:p
	  // ۂ̂ƂAԂxCBiDWORDPʂŏłȂ߁j
	  // ܂true color̂ق}VB́A8x86̏hƂ悤ȂB

#if 0
		BYTE* p = (BYTE*)dddesc.lpSurface;
		// Fϊe[uĂ܂I
		// ꂪbytePʂxƂb邪...
		BYTE table[256];
		for(int i=0;i<256;i++){
			table[i] = (BYTE)(i * brightness >> 8);
		}

		DWORD width = m_nScreenXSize;
		for(int y=0;y<m_nScreenYSize;y++){
			/*
			for (int x=0;x<m_nScreenXSize;x++) {
				*p = table[*p]; p++; // e[u@(C)yaneurao
				*p = table[*p]; p++;
				*p = table[*p]; p++;
			}
			p += lPitch - m_nScreenXSize*3; // PX^̑(bytes)
			*/

			// BYTEANZXĂϒxȂ
			_asm {
				mov ecx,width // Counter
				mov edx,p
				lea ebx,table
				xor eax,eax	 // reset
			slp:
				// STOSBgȁ[
				mov al,[edx]
				mov al,[ebx+eax]
				mov [edx],al
				inc edx
				mov al,[edx]
				mov al,[ebx+eax]
				mov [edx],al
				inc edx
				mov al,[edx]
				mov al,[ebx+eax]
				mov [edx],al
				inc edx
				loop slp
			}
			p += lPitch;
		}
#endif
//////////// Ă̂Q ///////////////////////////////////////////////////////
		BYTE table[256];
		for(int i=0;i<256;i++){
			table[i] = (BYTE)(i * brightness >> 8);
		}
		DWORD* p = (DWORD*)dddesc.lpSurface;
		int LP = m_nScreenXSize * 3 >> 2;
		for(int y=0;y<m_nScreenYSize;y++){
			_asm {
				push edi
				push esi
				lea edi,table
				mov esi,p
				mov ecx,LP	// loop counter
				xor ebx,ebx
			lpp:	// [vłSoCg
				mov eax,[esi]
				mov bl,al
				mov dl,[edi+ebx]
				mov bl,ah
				mov dh,[edi+ebx]

				mov [esi],dx
				shr eax,16
				mov bl,al
				mov dl,[edi+ebx]
				shr eax,8
				mov dh,[edi+eax]

				mov [esi+2],dx
				add esi,4

				loop lpp
				pop esi
				pop edi
			}
		
			p = (DWORD*) ((BYTE*)p+ lPitch);
		}

		   } break;

	  case 32: {
		DWORD RMask, GMask, BMask;

		RMask = dddesc.ddpfPixelFormat.dwRBitMask;
		GMask = dddesc.ddpfPixelFormat.dwGBitMask;
		BMask = dddesc.ddpfPixelFormat.dwBBitMask;

		DWORD *p = (DWORD*)dddesc.lpSurface;
		
		for(int y=0;y<m_nScreenYSize;y++){
			for (int x=0; x<m_nScreenXSize;x++) {
				DWORD pixel, px;
				px	= p[x];
				// ӂN[HVȂȂ...
				// ULONGLONGô͂ƑlȂ悤ȋC邯:p
				pixel  = (DWORD)((((ULONGLONG)(px&RMask))*brightness)>>8)&RMask;
				pixel |= (DWORD)((((ULONGLONG)(px&GMask))*brightness)>>8)&GMask;
				pixel |= (DWORD)((((ULONGLONG)(px&BMask))*brightness)>>8)&BMask;
				p[x] = pixel;
			}
			p = (DWORD*)((BYTE*)p + lPitch); // PX^̑
		}

	  } break; // end case
	} // end switch 
	m_lpSecondary->Unlock(NULL);
  } // end if
}


// ʂ̍XVII
void CDirectDraw::DrawScreen(void){
	if ((m_lpPrimary==NULL)||(m_lpSecondary==NULL)) return ; // [I
//	if (!m_bDirty) return ; // ʉĂւI

	// Slayerblt
	for(int i=0;i<m_BltScreenList.size();i++){
		m_BltScreenList[i](); // R[obNo^Ăׂ̂ČĂяo
	}

	if (m_BltHDCScreenList.size()) {
		HDC hdc;
		if (BeginPaintSecondary(hdc)==0) {
			for(int i=0;i<m_BltHDCScreenList.size();i++){
				m_BltHDCScreenList[i](hdc); // R[obNo^Ăׂ̂ČĂяo
			}
			EndPaintSecondary();
		}
	}

	// Brightness̎i߂ԂȂB]A̂ف[ԂႤHj
	RealizeBrightness(m_nBrightness,false);

	//	AobNAbvv[ɃXibv邱ƂvĂ̂Ȃ
	if (m_bBackup) {
		BackupBltScreen();
		m_bBackup = false;
		ClearSecondary();	// OnPaintvƂ炽܂:p
		return ;	//	̂ƂA`͍sȂȂidlj
	}

	// Smouse layerblt
	for(i=0;i<m_BltMouseScreenList.size();i++){
		m_BltMouseScreenList[i](); // R[obNo^Ăׂ̂ČĂяo
	}

	BltScreen();

	// ōXV̂AłFlip҂ł\͂...
	// Ė{́AScanLineoPaletteύXׂ...
	// ǂ̂ƂAAIȃpbg̃ACY͕sȂ̂ł
	RealizeBrightness(m_nBrightness,true);
}

void CDirectDraw::FlushPalette(void){	// ܂pbg̃tbV
	m_bBrightnessChanged = true;
	RealizeBrightness(m_nBrightness,true);
}

void CDirectDraw::BackupBltScreen(void) {
	if (m_BackupPlane->GetSurface()!=NULL) {
		RECT r; // source rect
		SetRect(&r,0,0,m_nScreenXSize,m_nScreenYSize);
		m_BackupPlane->GetSurface()->BltFast(0,0,m_lpSecondary,&r,DDBLTFAST_WAIT);
	}
}

void CDirectDraw::BltScreen(void){ // ʂ̓]̂
	if ((m_lpPrimary==NULL)||(m_lpSecondary==NULL)) return ; // [I

	RECT r; // source rect
	SetRect(&r,0,0,m_nScreenXSize,m_nScreenYSize);

	if (m_nSecondaryOffsetX || m_nSecondaryOffsetY) {
	//	]ItZbgĂ̂H
		RECT r2; // distination rect
		SetRect(&r2,0,0,m_nScreenXSize,m_nScreenYSize);	//	TCYƉ肵ėǂ
		//	a clipping algorithm
		//		between same size rect (C) yaneurao'1999
		if (m_nSecondaryOffsetX>0) {
			r.right		-= m_nSecondaryOffsetX;
			r2.left		+= m_nSecondaryOffsetX;
		} else {
			r.left		-= m_nSecondaryOffsetX;
			r2.right	+= m_nSecondaryOffsetX;
		}
		if (m_nSecondaryOffsetY>0) {
			r.bottom	-= m_nSecondaryOffsetY;
			r2.top		+= m_nSecondaryOffsetY;
		} else {
			r.top		-= m_nSecondaryOffsetY;
			r2.bottom	+= m_nSecondaryOffsetY;
		}
		
		//	蔲Ȃ̂ŃZJ_炵GDI BltɔΉI
		switch (m_ScreenMode){
		case FullScreenMode:{
		// tXN[łABltȂ̂I
			DDBLTFX fx;
			ZERO(fx);	//	ꉞ
			fx.dwSize = sizeof(fx);
			fx.dwFillColor = m_dwFillColor;
			RECT br;
			SetRect(&br,0,0,m_nScreenXSize,r2.top);					//	̈
			m_lpPrimary->Blt(&br,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx);
			//	main摜
			m_lpPrimary->BltFast(r2.left,r2.top,m_lpSecondary,&r,DDBLTFAST_WAIT);
			SetRect(&br,0,r2.top,r2.left,r2.bottom);				//	̈
			m_lpPrimary->Blt(&br,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx);
			SetRect(&br,r2.right,r2.top,m_nScreenXSize,r2.bottom);	//	Ë
			m_lpPrimary->Blt(&br,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx);
			SetRect(&br,0,r2.bottom,m_nScreenXSize,m_nScreenYSize);	//	̈
			m_lpPrimary->Blt(&br,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx);
		
			break;
						}
	case WindowMode: {
		// DirectDrawClipper𗘗pɂBltɂȂĂ͂ȂȂB
		// AȂ񂿂[Bɂė~>ClipperNI
			POINT cp;
			cp.x = cp.y = 0;
			ClientToScreen(m_hWnd,&cp); // NCAgEBhD̋`I

			DDBLTFX fx;
			ZERO(fx);	//	ꉞ
			fx.dwSize = sizeof(fx);
			fx.dwFillColor = m_dwFillColor;

			RECT br;
			SetRect(&br,0,0,m_nScreenXSize,r2.top);					//	̈
			OffsetRect(&br,cp.x,cp.y);
			m_lpPrimary->Blt(&br,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx);
			
			//	main摜
			br = r2;
			OffsetRect(&br,cp.x,cp.y);
			m_lpPrimary->Blt(&br,m_lpSecondary,&r,DDBLT_WAIT,NULL);

			SetRect(&br,0,r2.top,r2.left,r2.bottom);				//	̈
			OffsetRect(&br,cp.x,cp.y);
			m_lpPrimary->Blt(&br,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx);
			SetRect(&br,r2.right,r2.top,m_nScreenXSize,r2.bottom);	//	Ë
			OffsetRect(&br,cp.x,cp.y);
			m_lpPrimary->Blt(&br,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx);
			SetRect(&br,0,r2.bottom,m_nScreenXSize,m_nScreenYSize);	//	̈
			OffsetRect(&br,cp.x,cp.y);
			m_lpPrimary->Blt(&br,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx);

			return ;
					 }
		}
		return ;
	}

	//	]ItZbgw肳ĂȂtc[̏ꍇ
	switch (m_ScreenMode){
	case FullScreenMode:{
		if (m_bUseGDIBlt) {
			HDC hdc,hdc2;
			if (BeginPaintSecondary(hdc2)==0){
				if ((hdc = GetDC(m_hWnd))!=NULL){
					::BitBlt(hdc,0,0,m_nScreenXSize,m_nScreenYSize,hdc2,0,0,SRCCOPY);
					ReleaseDC(m_hWnd,hdc);
				}
				EndPaintSecondary();
				return ;
			}
		}
		// tXN[ȂABltFastłH
		if (m_bUseDirectDrawFlip2){
			if (m_lpPrimary->Flip(NULL,DDFLIP_WAIT)!=DD_OK) {
//				  RestoreSurface();
			};
		} else {
			if (m_lpPrimary->BltFast(0,0,m_lpSecondary,&r,DDBLTFAST_WAIT)!=DD_OK){
//				  RestoreSurface();
			}
		}
		break;
						}
	case WindowMode: {
		// DirectDrawClipper𗘗pɂBltɂȂĂ͂ȂȂB
		// AȂ񂿂[Bɂė~>ClipperNI
		if (m_bUseGDIBlt) {
			HDC hdc,hdc2;
			if (BeginPaintSecondary(hdc2)==0){
				if ((hdc=GetDC(m_hWnd))!=NULL){
					RECT sr;
					GetClientRect(m_hWnd,&sr);
					::BitBlt(hdc,sr.left,sr.top,sr.right,sr.bottom,hdc2,0,0,SRCCOPY);
					ReleaseDC(m_hWnd,hdc);
				}
				EndPaintSecondary();
				return ;
			}
		} else {
			POINT cp;
			cp.x = cp.y = 0;
			ClientToScreen(m_hWnd,&cp); // NCAgEBhD̋`I

			RECT sr = r;
			OffsetRect(&sr,cp.x,cp.y);
		
			if (m_lpPrimary->Blt(&sr,m_lpSecondary,&r,DDBLT_WAIT,NULL)!=DD_OK){
//			RestoreSurface();	// ܂W^o^ĂdȂ:p
			}
			return ;
		}
					 }
	}
	return ;
}

//////////////////////////////////////////////////////////////////////////////

void CDirectDraw::SetFillColor(DWORD dwFillColor){
	m_dwFillColor = dwFillColor;
	m_nFillColorRGB = -1; // RGBw͎gpȂ
}

void CDirectDraw::SetFillColorRGB(COLORREF rgb){
	m_dwFillColor = CPlane::DDColorMatch(m_lpSecondary,rgb);
	m_nFillColorRGB = rgb; // ݒlۑ
}

DWORD CDirectDraw::GetFillColor(void){
	return m_dwFillColor;
}

LRESULT CDirectDraw::ClearSecondary(void){ // ZJ_T[tF[X̃NA
	if (m_lpSecondary==NULL) return 1;

	DDBLTFX fx;
	ZERO(fx);	//	ꉞAǉ
	fx.dwSize = sizeof(fx);
	fx.dwFillColor = m_dwFillColor;
	if (m_lpSecondary->Blt(NULL,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx)!=DD_OK){
//		RestoreSurface();
		return 2;
	}
	return 0;
}

LRESULT CDirectDraw::ClearSecondary(RECT &r){ // ZJ_T[tF[X̃NA
	if (m_lpSecondary==NULL) return 1;

	DDBLTFX fx;
	ZERO(fx);	//	ꉞĂقǂ...
	fx.dwSize = sizeof(fx);
	fx.dwFillColor = m_dwFillColor;
	if (r.left< 0) r.left	=	0;
	if (r.top < 0) r.top	=	0;
	if (r.right>m_nScreenXSize ) r.right	= m_nScreenXSize;
	if (r.bottom>m_nScreenYSize) r.bottom	= m_nScreenYSize;

	if (m_lpSecondary->Blt(&r,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx)!=DD_OK){
//		RestoreSurface();
		return 2;
	}
	return 0;
}

LRESULT CDirectDraw::BeginPaintSecondary(HDC &hdc){
	if (m_lpSecondary==NULL) {
		InnerLog("CDirectDraw::BeginPaintSecondarylpSecondaryNULL");
		hdc = NULL;
		return 1;
	}

	if (m_lpSecondary->GetDC(&m_hDDSDC)!=DD_OK){
		m_lpSecondary->Restore();
		if (m_lpSecondary->GetDC(&m_hDDSDC)!=DD_OK){	
			InnerLog("BeginPaintSecondaryGetDCɎs");
			m_hDDSDC = NULL;
			hdc = NULL;
			return 2;
		}
	}
	hdc = m_hDDSDC;
	return 0;
}
	
LRESULT CDirectDraw::EndPaintSecondary(void){
	if (m_lpSecondary==NULL) return 1;
	if (m_hDDSDC!=NULL)	{
		m_lpSecondary->ReleaseDC(m_hDDSDC);
		m_hDDSDC = NULL;
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CDirectDraw::RealizePalette(CPlane&plane){ // PalneNo.̃pbgACY
	// 256F[hPaletteĂȂꍇAŏɊ蓖ĂĂpbgɖ߂Kv̂...
	// ANULLłĂA65536F256ɈڍsƂ̂ߐݒ肵ĂKv

	CPlane::m_lpPalettePlaneNow = &plane; // SetPalette͕`^C~OōsȂƁI
	m_bBrightnessChanged = true; // ύXׂ
	return 0;
}

/////////////////////////////////////////////////////////////////////

void CDirectDraw::SetBrightness(int brightness){
	if (m_nBrightness != brightness) {
		m_bBrightnessChanged = true;
		m_nBrightness = brightness;
	}
}

int CDirectDraw::GetBrightness(void){
	return m_nBrightness;
}

/////////////////////////////////////////////////////////////////////
void CDirectDraw::FlipToGDISurface(void){
// tXN[[hFlipgpݒłȂ
	if (m_ScreenMode == FullScreenMode && m_bUseDirectDrawFlip2) {
		if (m_lpDirectDraw!=NULL) {
		   m_lpDirectDraw->FlipToGDISurface();
		}
	}
}

LRESULT CDirectDraw::SetDisplayMode(EScreenMode ScrMode,int x,int y,int colordepth){
	// x,y,colordepth0 Ȃ΂܂̂܂܁iOݒ肳ꂽ̂̂܂܁jύXB
	// WindowModeȂcolordepth͖B
	// iFullScreenModeɐ؂ւƂA̒l͈Ӗj
	// ύX̌ʂ́AGetDisplayModeŎ擾ł

	m_ScreenMode = ScrMode;
	if (x!=0) m_nScreenXSize = x;
	if (y!=0) m_nScreenYSize = y;
	if (colordepth!=0) m_nScreenColorMode = colordepth;

	if (m_lpPrimary==NULL) return 0; // ܂vC}oƂ

	// EBhDƃT[tF[XȂƂ̂ႤH
	return ChangeDisplayMode();
}

LRESULT CDirectDraw::GetDisplayMode(EScreenMode &ScrMode,int &x,int &y,int &colordepth){
	ScrMode	   = m_ScreenMode;
	x		   = m_nScreenXSize;
	y		   = m_nScreenYSize;
	colordepth = m_nScreenColorMode2;

	return 0;
}

void	CDirectDraw::GetScreenSize(int &x,int &y){
	x		   = m_nScreenXSize;
	y		   = m_nScreenYSize;
}

// Q[xẻʁiAvɐ؂ւƂ̏j
void CDirectDraw::DisplayPaused(void){
	ClearSecondary();
	HDC hdc;
	if (BeginPaintSecondary(hdc)==0){
		char buf[256];
		wsprintf(buf,"Game is paused... This is not a bug !!");
		::SetTextColor(hdc, RGB(255,255,255));
		::SetBkMode(hdc, TRANSPARENT);
		::TextOut(hdc, 160,230,buf,strlen(buf));
		EndPaintSecondary();
	}
	BltScreen();	
}

void CDirectDraw::ShowCursor(bool bShow){
	if (bShow==m_bNowShowCursor) return ; // ȂύXKvȂ
	::ShowCursor(bShow);
	m_bNowShowCursor = bShow;
}

void CDirectDraw::SetSystemMemoryUse(bool bUseSystemMemory){
	if (bUseSystemMemory!=m_bUseSystemMemory){
		m_bUseSystemMemory = bUseSystemMemory;
		ChangeDisplayMode(); // T[tFCX̍č쐬		
	}
}

bool CDirectDraw::GetSystemMemoryUse(void){
	return m_bUseSystemMemory;
}

void CDirectDraw::SetGDIBltUse(bool bUseGDIBlt){ // GDIɂBltsȂ̂H
	m_bUseGDIBlt = bUseGDIBlt;
}
	
bool CDirectDraw::GetGDIBltUse(void){
	return	m_bUseGDIBlt;
}

int CDirectDraw::GetBpp(void){
	return m_nScreenColorMode2;
}

LRESULT CDirectDraw::SetSecondaryOffset(int ox,int oy){
	//	ZJ_̓]ItZbg added '99/12/1
	m_nSecondaryOffsetX = ox;
	m_nSecondaryOffsetY = oy;
	return 0;
}

/*
BYTE CDirectDraw::GetNearestPalette(COLORREF rgb){
	PALETTEENTRY pal[236]; // 236FQbg
	if (m_lpPaletteMain==NULL) return 0; // ȂłH
	if ((m_lpPaletteMain->GetEntries(0,10,236,pal))==DD_OK){
	// ԋ߂pbgGDIɒT
		int j=0,d,dmax,dr,db,dg;
		dmax = 0xfffff;
		for(int i=0;i<236;i++){
			dr = ((rgb & 0xff)		- pal[i].peRed);
			dg = (((rgb>>8) & 0xff) - pal[i].peGreen);
			db = (((rgb>>16)& 0xff) - pal[i].peBlue);
			if ((d=(dr*dr+dg*dg+db*db)) < dmax) {
				dmax = d;
				j = i;
			}
		}
		return j+10;
	}
	return 0;
}
*/
//////////////////////////////////////////////////////////////////////////////
//	obNAbvv[̋@\

void	CDirectDraw::EnableBackupPlane(bool b){
	//	obNAbvv[LA
	if (b) {
		if (m_BackupPlane==NULL) {
			m_BackupPlane = new CPlane;
			m_BackupPlane->CreateSurface(m_nScreenXSize,m_nScreenYSize);	//	ʃTCỸv[
		}
	} else {
		DELETE_SAFE(m_BackupPlane);
	}
}
	
void	CDirectDraw::SnapToBackupPlane(void){	//	̉ʕ`^C~OŉʂBackupPlaneɂ܂邲ƃRs[
	m_bBackup = true;
}
	
LRESULT	CDirectDraw::BltFromBackupPlane(void){	//	BackupPlaneZJ_֓]
	if (m_BackupPlane==NULL) return -1;
	return m_BackupPlane->BltFast(0,0);	//	ꂾH
}


//////////////////////////////////////////////////////////////////////////////

LRESULT CDirectDraw::WndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam){ // bZ[W̃R[obN
	if (hWnd!=m_hWnd) return 0;

	switch(uMsg){
	case WM_ACTIVATEAPP: {
		UINT bActive = wParam;
		if(bActive) {
			CheckSurfaceLost();		//	T[tF[X̃Xg̃`FbN
			if (m_nFillColorRGB!=-1) SetFillColorRGB(m_nFillColorRGB); // FillColor̕A
		}
		return 0;
	}
	case WM_PAINT: {
		// `p̃obt@́AɗpӂĂB
		BltScreen();	//	܂邲bltiʓ|̂:pj
		//	蔲WM_PAINTȂĂȂɔȂ̂ŁAŏ\c
		
		return 0; // DefaultKv
				   } // end case

/*
	case WM_PALETTECHANGED: {
	// {ȂWM_PALETTECHANGEDɉăpbg}bv
	// ĕ`悷Kv邪A߂ǂ̂ŏȗ
		if ((HWND)wParam == m_hWnd) return 0; // SetPalette񂩁H
//		m_bPaused = true;
		return 0;
	}
*/

	case WM_QUERYNEWPALETTE:
	// ̃bZ[Wtrue
	if (m_lpPrimary!=NULL && m_lpPaletteMain!=NULL && m_ScreenMode!=FullScreenMode){
		if (m_lpPrimary->SetPalette(m_lpPaletteMain)== DDERR_SURFACELOST ) {
			if (m_lpPrimary->Restore()!=DD_OK) { return 0; /* s... */ }
			if (m_lpPrimary->SetPalette(m_lpPaletteMain)!=DD_OK){
				InnerLog("DirectDraw::OnQueryNewPaletteSetPaletteɎs");
				return 0;
			}
		}
		m_bBrightnessChanged = true;	// ́Ã^C~OŃtbVׂ
		FlushPalette();
		if (m_nFillColorRGB!=-1) SetFillColorRGB(m_nFillColorRGB); // FillColor̕A
		CPlane::RestoreAll2();			// ɃI[i[h[nPlane̕AR[h

		return 0;
	}
	return 0;

	case WM_SETCURSOR: {
		if (m_ScreenMode == FullScreenMode ) {
			::SetCursor(NULL);	// }EX͕KOŕ`I
		}
		return 0;
	}

	} // end switch

	return 0;
}
