// yaneDirectDraw.h
//	 This is DirectDraw wrapper.
//		programmed by yaneurao(M.Isozaki) '99/06/20
//

#ifndef __yaneDirectDraw_h__
#define __yaneDirectDraw_h__

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#pragma warning(disable:4786)
#include <vector>				//	STL
using namespace std;

#include <imm.h>	// for ImmAssociateContext
#pragma comment(lib,"imm32.lib")

// DirectDraŵ́AVC^[tF[XgȂDirectX3ŏ\ł...
#ifndef DIRECTDRAW_VERSION
#define DIRECTDRAW_VERSION 0x0300
#endif
#include <ddraw.h>		// DirectDraw header

#ifndef __ESCREENMODE__
#define __ESCREENMODE__
enum EScreenMode { FullScreenMode,WindowMode };
#endif

#include "yaneWinHook.h" // WindowMessageHooker
#include "yanePlane.h"	 // CPlane
#include "yaneWindow.h"	//	ǁAƂ͐؂Ă؂Ȃ֌Wɂ
#include "yaneWrapBase.h"

typedef vector<void (*)(void)> CFuncList;	   // `掞ɃR[obN֐Xg
typedef vector<void (*)(HDC)> CHDCFuncList;	   // `掞ɃR[obN֐Xg

class CPlane;
// DirectDraw wrapper
class CDirectDraw : public CWinHook,public CWrapBase {
public:
	//	from CWrapBase
	LRESULT		Initialize(HWND hWnd,HINSTANCE hInst);
	LRESULT		Terminate(void);
	
	//////////////////////////////////////////////////////////////////////////
	//	Window Maker
	HWND		CreateDrawWindow(HINSTANCE hInst,string appName);

	// fBXvC[hiSetDisplayModeňꔭύX\j
	LRESULT		SetDisplayMode(EScreenMode ScrMode,int x=0,int y=0,int colordepth=0);
	LRESULT		GetDisplayMode(EScreenMode &ScrMode,int &x,int &y,int &colordepth);
	void		GetScreenSize(int &x,int &y);	// GetDisplayModex,y
	EScreenMode GetScreenMode(void) { return m_ScreenMode; }
	int			GetBpp(void);	// ݂Bpp̎擾(cf.CPlane::GetBpp)
	void		SetSystemMemoryUse(bool bUseSystemMemory); // T[tFCXVXezu邩H
	bool		GetSystemMemoryUse(void);
	void		SetDirectDrawFlipUse(bool);	// fullscreenDirectDrawFlipgH
	bool		GetDirectDrawFlipUse(void);	// 擾


	// eXgȂ̃fBXvC[hύX
	// BeginChangeDisplayTestDisplayModeEndChangeDisplayƃubNŎg
	void		BeginChangeDisplay(void);
	void		TestDisplayMode(EScreenMode scrmode,int nSX,int nSY,int nColor);
	LRESULT		EndChangeDisplay(void);

	//////////////////////////////////////////////////////////////////////////

	// ̊֐AĂ݂͂APaletteGDIĂȂ߁A256[h
	// ł͐ɓ삵ȂA肪̂Ŏgp֎~:p
	void	SetGDIBltUse(bool bUseGDIBlt); // GDIɂBltsȂ̂H
	bool	GetGDIBltUse(void);

	//////////////////////////////////////////////////////////////////////////

	// `֘A
	void	DrawScreen(void);			// ʂۂɕ`悷(܂)
	void	BltScreen(void);			// ZJ_̓]̂(WM_PAINTp)
	CFuncList m_BltScreenList;			// `掞ɃR[obN֐Q
	CHDCFuncList m_BltHDCScreenList;	// `掞ɃR[obN֐Q
	CFuncList m_BltMouseScreenList;		// MouseJ[\`pR[obNXg

	void	SetFillColor(DWORD dwFillColor); // wi̓hԂF
	void	SetFillColorRGB(COLORREF rgb);	 // hԂFRGBlŎw
	DWORD	GetFillColor(void);

	LRESULT	ClearSecondary(void);		// ZJ_T[tF[X̃NA
	LRESULT	ClearSecondary(RECT &r);	// `œhԂ(SetFillColor̐F)
	LRESULT SetSecondaryOffset(int ox,int oy);	//	ZJ_̓]ItZbg
	//////////////////////////////////////////////////////////////////////////

	// ڏ
	LRESULT BeginPaintSecondary(HDC& hdc); // ڏāI
	LRESULT EndPaintSecondary(void);	   // ڏI

	//////////////////////////////////////////////////////////////////////////

	// pbg֘A
	LRESULT RealizePalette(CPlane &plane);	// CPlanẽpbgACY
	void	SetBrightness(int bright);		// ʂ̖邳ݒ(0`256)
	int		GetBrightness(void);			// ʂ̖邳擾(0`256)
	void	FlushPalette(void);				// RealizePaletteĂ̂܂flush

	//////////////////////////////////////////////////////////////////////////

	// ̑
	void	FlipToGDISurface(void);		// GDISurfaceɐ؂ւ(flipgp)
	void	ShowCursor(bool bShow);		// }EXJ[\̕\^\
	LRESULT CheckSurfaceLost(void);		// SurfaceׂĂ畜(WM_ACTIVATEAPPł)

	//	backup plane
	void	EnableBackupPlane(bool b);	//	obNAbvv[LA
	void	SnapToBackupPlane(void);	//	̉ʕ`^C~OŉʂBackupPlaneɂ܂邲ƃRs[
	LRESULT	BltFromBackupPlane(void);	//	BackupPlaneZJ_֓]
	CPlane* GetBackupPlane(void) { return m_BackupPlane; }	//	obNAbvv[Ԃ

	//	MouseLayer̐ݒ

	//	܂
	void	DisplayPaused(void);		// Av؂ւPausebZ[W\(256F)
	CGameWindow* GetGameWindow(void) { return &m_GameWindow; }

	//	܂Q
	LPDIRECTDRAWPALETTE GetMainPalette(void) { return m_lpPaletteMain; }
	LPDIRECTDRAWSURFACE GetSecondary(void) { return m_lpSecondary; }
	
	//////////////////////////////////////////////////////////////////////////

	CDirectDraw(void);
	~CDirectDraw(void);

////////////////////////////////////////////////////////////////////////////////////////
protected:
	static LPDIRECTDRAW m_lpDirectDraw;	 // C^[tF[X
	bool m_bSucessInit;					 // COM͐̂H

	//	āAǂ݌vł͂ȂB
	//	̃EBhDT|[gƂ́ÂւύXKv
	LPDIRECTDRAWSURFACE m_lpPrimary;	 // vC}T[tF[X
	LPDIRECTDRAWPALETTE m_lpPaletteMain; // ۂSetPalettê͂{ɍi

	friend class CPlane;
	static LPDIRECTDRAWSURFACE m_lpSecondary;	 // obNobt@
	static LPDIRECTDRAWCLIPPER m_lpClipper;	 // Nbp[
	static int m_nScreenXSize;			// ʃTCY
	static int m_nScreenYSize;			//

	EScreenMode m_ScreenMode;	// ݂̃XN[[h
	int m_nScreenColorMode;		// 8 = 256F[h , 16 = 65536F ,24,32...[U[̊]
	int m_nScreenColorMode2;	// :p
	bool m_bUseDirectDrawFlip;	//	fullscreenDirectDrawFlipgHi[U[̊]j
	bool m_bUseDirectDrawFlip2; //	fullscreenDirectDrawFlipgHiۂ̂Ƃj
	bool m_bUseSystemMemory;	//	T[tFCXVXeɔzûH
	bool m_bUseGDIBlt;			//	T[tFCXBitBltœ]̂H

	CGameWindow* m_lpGameWindow;		//	ΉCGameWindowւ̃|C^

	DWORD	m_dwFillColor;				// wiŏɓhԂF
	COLORREF m_nFillColorRGB;			//	̂RGBo[W

	LRESULT InstallPalette(void);
	void	RealizeBrightness(int brightness,bool bAfterDraw); // Brightness̎
	bool	m_bBrightnessChanged;		// Brightness͕ύXꂽ̂
	bool	m_nBrightnessChanged;		// Brightness͕ύXꂽ̂
	CPlane*	m_lpAttachedPalettePlane;	// A^b`ĂPalettePlane(\tgI)
	int		m_nBrightness;				// ʂ̖邳(0-256)

	CPlane*	m_BackupPlane;				//	obNAbvv[
	bool	m_bBackup;					//	̕`^C~OBackupPlaneɃXibv̂
	void	BackupBltScreen(void);		//	obNAbvblt

	int		m_nSecondaryOffsetX;		//	ZJ_̓]ItZbg
	int		m_nSecondaryOffsetY;

	//////////////////////////////////////////////////////////////////////////

	LRESULT	ChangeDisplayMode(void);	// fBXvC[h̕ύX(surface̕)
	bool	m_bDisplayChanging; // BeginChangeDisplay`EndChangeDisplayԒH

	//////////////////////////////////////////////////////////////////////////

	HDC		m_hDDSDC;		// DirectDrawSurfaceHDCۊǗp
	bool	m_bNowShowCursor;	// }EXJ[\`悷̂H
	HIMC	m_hIME;			// IMEnhۑp

	//////////////////////////////////////////////////////////////////////////
	//	܂ǂ݌vł͂Ȃc
	CGameWindow	m_GameWindow;

	//	from CWinHook
	LRESULT WndProc(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam); // bZ[W̃R[obN
};

#endif
