// DirectInput Wrapper

#include "yaneDirectInput.h"
#include "yaneCOM.h"
#include "yaneError.h"
#include "yaneMacro.h"

// COMIďoł́ADirectInput̃C^[tF[XȂ
// iWindowsNT4.0+ServicePack3) IDirectInputGUIDႤB
//	 ́AMicrosoft̃`{ƎvB
// dȂ̂ŁAňLoadLibraryB

	HINSTANCE __hDirectInputDLL = NULL;

//////////////////////////////////////////////////////////////////////////////
CDirectInput::CDirectInput(void){
	m_lpDirectInput=NULL;
	m_lpDIKeyDev=NULL;

	if (CYCOM::AddRef()) { // COMgŁ[
		m_bSuccessInit = false;
	} else {
		m_bSuccessInit = true;
	}
}

CDirectInput::~CDirectInput(){
	Terminate(); // sȎ҂̂߂ɈꉞAI:p

	CYCOM::Release(); // COMgIŁ[

	// 邢́ALoadLibraryĂH
	if (__hDirectInputDLL!=NULL) FreeLibrary(__hDirectInputDLL);

}

//////////////////////////////////////////////////////////////////////////////

LRESULT CDirectInput::Initialize(HWND hWnd,HINSTANCE hInst){  // 
	Terminate(); // IɂďiÔ߁j

	m_nKeyBufNo=0;	// ƕ\flipāAƂ̂ɗp
	ZERO(m_byKeyBuffer);

	if(!m_bSuccessInit) {
		InnerLog("DirectInput::CoInitializeɎsBOLEsǁH");
		return 1;
	}

	if (CoCreateInstance(CLSID_DirectInput,NULL,CLSCTX_INPROC_SERVER,
		IID_IDirectInput, (VOID**)&m_lpDirectInput)!=DI_OK){

//		InnerLog("DirectInput::InitializeCoCreateInstanceɎs");
//		NTł́AǂsDDDB

		goto UseLoadLibrary;
	}

	if(m_lpDirectInput==NULL) {
		InnerLog("DirectInputInterfaceȂ"); // DirectX3͓Ƃ̂H
		return 2;
	}

	if(m_lpDirectInput->Initialize(hInst,DIRECTINPUT_VERSION)!=DI_OK){
		InnerLog("DirectInputłȂ");
		return 3;
	}

	goto skip;

UseLoadLibrary:

	// bnlIďoɂ
	__hDirectInputDLL = LoadLibrary("dinput.dll");
	if (__hDirectInputDLL==NULL) {
		InnerLog("DirectInputLoadLibraryɎs");
		return 4;
	}

	{ // dica̓[JIuWFNg
		typedef LRESULT (WINAPI *dica_proc)(HINSTANCE hinst,DWORD dwVersion,LPDIRECTINPUTA *ppDI,
									LPUNKNOWN punkOuter);
		dica_proc dica = (dica_proc)GetProcAddress(__hDirectInputDLL,"DirectInputCreateA");
		if (dica == NULL) {
			InnerLog("DirectInputGetProcAddressɎs");
			return 5;
		}
		if (dica(hInst, DIRECTINPUT_VERSION, &m_lpDirectInput, NULL)!=DI_OK){
			InnerLog("DirectInput::DirectInputCreateɎs");
			return 6;
		}
	}

skip:

	//L[{[hfoCX̍쐬
	if (m_lpDirectInput->CreateDevice(GUID_SysKeyboard
			,&m_lpDIKeyDev,NULL)!=DI_OK){
		InnerLog("DirectInput̏CreateDeviceɎs");
		return 7; // [...
	}

	//	L[{[htH[}bg̐ݒ
	if(m_lpDIKeyDev->SetDataFormat(&c_dfDIKeyboard)!=DI_OK){
		RELEASE_SAFE(m_lpDIKeyDev);
		InnerLog("DirectInput̏SetDataFormatɎs");
		return 8;
	}

	// WindowNTœ삳ɂ́ÁA
	// DISCL_FOREGROUND | DISCL_NONEXCLUSIVEłȂĂ͂ȂB
	if (m_lpDIKeyDev->SetCooperativeLevel(hWnd,
			DISCL_FOREGROUND | DISCL_NONEXCLUSIVE)!=DI_OK){
		RELEASE_SAFE(m_lpDIKeyDev);
		InnerLog("DirectInput̏SetCooperativeLevelɎs");
		return 9;
	}

//	MsgHook(hWnd); // WindowMessageHook

	m_bDIKeyAcquire=false;

	// L[L
	if (m_lpDIKeyDev->Acquire()!=DI_OK){
		m_bDIKeyAcquire = false;
		// InnerLog("DirectInput̏KeyAcquireɎs");
		return 0;
		// ́AAcquireɂ́A
		// EBhDtH[JXKvȂ̂ŁA͗L肤B
		// ܂bZ[WƂ񂩂
		// ACTIVATEAPP߂܂ւ񂵂ȁ[i΁j
	}
	m_bDIKeyAcquire = true;

	return 0;
}
// ---------------------------------------------------------------------------
LRESULT CDirectInput::Terminate(void){ // I

//	MsgUnhook(); // WindowMessageUnhook

	// lĂfoCX̉
	if(m_lpDIKeyDev!=NULL){
		m_lpDIKeyDev->Unacquire();
		RELEASE_SAFE(m_lpDIKeyDev);
	}

	RELEASE_SAFE(m_lpDirectInput);	// COMIɌĂяoĂ̂ŁAŉI

	return 0; // I
}

// ---------------------------------------------------------------------------

LRESULT CDirectInput::GetKeyState(void){

	if (m_lpDIKeyDev==NULL) {
		return 1;	// foCXȂ̂ɌĂԂȁ[I
	}

	//	obt@flip!
	FlipKeyBuffer(m_nKeyBufNo);

	/*
	// ANeBûƂ́AGetDeviceStatesˁ[
	if (bUnActive) {
		return 2;
	}
	*/

	LRESULT hr;
again:
	// AcquireĂȂ̂GetDeviceState炨Ȃ
	if (m_bDIKeyAcquire) {
		hr = m_lpDIKeyDev->GetDeviceState(256,
				(LPVOID)&(m_byKeyBuffer[m_nKeyBufNo][0]));
		if (hr==DIERR_INPUTLOST){
		// Av؂ւuԂ͂[Ȃ̂	
			hr=m_lpDIKeyDev->Acquire();
			if (hr==DI_OK) goto again;	// 񂾂Ȃ狖:p
			// ȂƂɂ
			m_bDIKeyAcquire = false;	//	ɂ܂lĂˁI:p
			//	obt@NAĖ߂BiʊOɃtH[JXڂƂɉςȂ
			//	ɂȂ̂h߁j
			ZeroMemory((LPVOID)&(m_byKeyBuffer[m_nKeyBufNo][0]),256);
			return 1; // s̊
			// InnerLog("GetKeyStateŃfoCXLOSTĂ");
		}
		if (hr==DI_OK) {
			return 0;
		} else {
			//	obt@NAĖ߂BiʊOɃtH[JXڂƂɉςȂ
			//	ɂȂ̂h߁j
			ZeroMemory((LPVOID)&(m_byKeyBuffer[m_nKeyBufNo][0]),256);
			return 1;
		}
	}
	// AcquireƂ̂
	hr=m_lpDIKeyDev->Acquire();
	if (hr==DI_OK) {
		m_bDIKeyAcquire=true;
		goto again;
	} else {
		m_bDIKeyAcquire=false;
		// ȂƂɂ:p
		//	obt@NAĖ߂BiʊOɃtH[JXڂƂɉςȂ
		//	ɂȂ̂h߁j
		ZeroMemory((LPVOID)&(m_byKeyBuffer[m_nKeyBufNo][0]),256);
		return 1;
	}
}

//////////////////////////////////////////////////////////////////////////////
//	0x80&ƂKvŁAoverrideقǂH
inline bool CDirectInput::IsKeyPress(int key) {
	return	(m_byKeyBuffer[m_nKeyBufNo][key] & 0x80) !=0;
};

inline bool CDirectInput::IsKeyPushDown(int key){
	// ꂽuԂtrueɂꍇ
	if (!(m_byKeyBuffer[  m_nKeyBufNo][key] & 0x80)) return false;
	if (  m_byKeyBuffer[1-m_nKeyBufNo][key] & 0x80) return false;
	return true;
}

//////////////////////////////////////////////////////////////////////////////
