
#include "yaneGameFrame.h"
#include "yaneFile.h"			// NfBNgJgƂ邽
#include "yaneMacro.h"

extern void GameMain(void);		// [U[ŗpӂꂽC֐

//////////////////////////////////////////////////////////////////////////////

// 킸ƒmꂽWinMain...
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdParam, int nCmdShow)
{
	TheSDK.Start(hInstance,lpCmdParam,nCmdShow);

	return 0;
}

//////////////////////////////////////////////////////////////////////////////
CGameFrame TheSDK;	// B̃AvP[VIuWFNg
//////////////////////////////////////////////////////////////////////////////
CGameFrame&		ysFrame =	TheSDK;
CDirectDraw&	ysDraw	=	TheSDK.yDD;
CDirectInput&	ysInput	=	TheSDK.yDI;
CElapseTime&	ysTime	=	TheSDK.yET;
/////////////////////////////////////////////////////////////////////////

// ---------------------------------------------------------------------------
CGameFrame::CGameFrame(void){
	CTimeBase::timeBeginPeriodMin();	//	NTŕ`肳邽

	DrawScene	= NULL;
	GameExit	= NULL;

	m_bFirstDraw= true;
	m_hWnd		= NULL;
	m_yaneMutex = NULL;

	m_AppName = "Ղ肿";
	
	m_bMultiApp = false;				// NȂ̂fBtHg
	m_bUsePause	= true;					// tH[JẌړɂƂȂGamePause邩

	m_bPaused	= false;
	m_bQuit		= false;

}

CGameFrame::~CGameFrame(){
	DELETE_SAFE(m_yaneMutex);

	CTimeBase::timeEndPeriodMin();		//	NTŕ`肳邽
}

// ---------------------------------------------------------------------------
//	WinMaiñGg[|Cg
// ---------------------------------------------------------------------------
LRESULT CGameFrame::Start(HINSTANCE hInst,LPSTR lpCmdParam,int nCmdShow){
	//	PDHINSTANCEƁAR}hCCR}hp[^̈n
	m_hInst		= hInst;
	strcpy(m_CmdParam,lpCmdParam);
	m_nCmdShow	= nCmdShow;

	//	QDCuŜĂ݂B
	if (Initialize()) return 1;	
	
	//	RDC̃bZ[W[v
	MessageLoop();
	
	return 0;
}

// ---------------------------------------------------------------------------
//	CuŜ̏
// ---------------------------------------------------------------------------

LRESULT CGameFrame::Initialize(void){
	//	P.CYFilȅ:NfBNgJgpXƂĐݒ
	char dir[_MAX_PATH];
	GetCurrentDirectory(_MAX_PATH,dir);
	CYFile::SetCurrentDirectory(dir);

	//	QD[U[ŗpӂꂽGg[|CgĂяo
	GameMain();				//	[U[̒`֐Ăяo
	if (m_bQuit) return 1;	//	[U[Quit()Ăяoꂽ

	//	RDdN̖h~
	if (!m_bMultiApp){
		m_yaneMutex = new yaneMutex; // ńA̃fXgN^sȂ

		//	NExeAdNh~MutexƂ
		char fileName[_MAX_PATH];
		GetModuleFileName(m_hInst,fileName,_MAX_PATH);
		
		//	Mutexɂ\͎gȂ̂+ɒu
		for(int i=0;i<_MAX_PATH;i++){
			if (fileName[i]=='\\') fileName[i] = '+'; // + ̓t@Cɂ͏oȂ̂łnj
			else if (fileName[i]=='\0') break;
		}

		if (m_yaneMutex->Open(fileName)) {	// ...
		//	̋Nt@CƓ̎st@CT̂{؂낤ԂȂ̂ŁDDDB
			HWND FirsthWnd;
			FirsthWnd = FindWindow(NULL,m_AppName.c_str());
			if (FirsthWnd==NULL) return 1;	// [ȁBÕEBhDȂ:p
			
			//	̃LvVEBhDȂ
			ShowWindow(FirsthWnd,SW_SHOWNORMAL);
			SetForegroundWindow(FirsthWnd);			// ɃtH[JXڂ
			return 1;
		}
	}

	//	SDȉ́AeW[ԂɏĂ䂭

	//	EBhDāÃnh擾B
	if ((m_hWnd = yDD.CreateDrawWindow(m_hInst,m_AppName))==NULL) {
		InnerLog("CGameFrame::CreateWindowɎs");
		MessageOut("CreateWindowɎs","ċN΂Ȃ邩H");
		return 1;
	}

	if (yDD.Initialize(m_hWnd,m_hInst)) {
		MessageOut("DirectDraw̏G[",ErrorMessage);
		MessageOut("蔭","DirectX3ȍ~ɃZbgAbvĂȂ̂ł́H");
		return 1;
	}

	if (yDI.Initialize(m_hWnd,m_hInst)) {
		MessageOut("DirectInput̏G[",ErrorMessage);
		MessageOut("蔭","DirectX3ȍ~ɃZbgAbvĂȂ̂ł́H");
		return 1;
	}

	//	ȉ̂́Ał:p@G[`FbN͂Ȃ
	CWrapBase *modules[]={ NULL };
	for(int i=0;modules[i]!=NULL;i++) {
		modules[i]->Initialize(m_hWnd,m_hInst);
	}

	return 0;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CGameFrame::Terminate(void){
	//	tŏI
	CWrapBase *modules[]={ &yDI,&yDD,NULL };
	for(int i=0;modules[i]!=NULL;i++) {
		modules[i]->Terminate();
	}

	return 0;
}

//////////////////////////////////////////////////////////////////////////////
void CGameFrame::MessageLoop(void){

	MsgHook(m_hWnd);	// WindowMessageHookn߂B
	//	tbNԂŌĂяo邱Ƃۏ؂̂ŁAĂяo͈ԍŌƂȂB
	//	ɂACDirectDraw,CDirectSound肠ƂCGameFrameĂяo邱Ƃ
	//	ۏ؂B(WM_ACTIVATEAPP̏ł́ÂƂdvj

	//	VOXbh̗zIȃbZ[W (c) yaneurao May.'99
	MSG msg;
	while (true) {
		if (PeekMessage(&msg, NULL, 0, 0 , PM_REMOVE)){
TransMes:
			if ( msg.message==WM_QUIT) break; // ...
			TranslateMessage(&msg);
			DispatchMessage(&msg);

			continue;
		} else {
			if (!m_bPaused) { // ANeBułȂ΃[U[֐~߂
				// [U[`֐ĂяoB
				if (DrawScene!=NULL) { // ֐`ĂȁH
					// ڂȂtrueɂď𑣂
					if (m_bFirstDraw) {
						m_bFirstDraw = false;	// fixed '00/02/23
						DrawScene(1);  // V[RXgN^Ăяo
						if (m_bQuit) continue;
					}
					DrawScene(0);	// ʏĂяoI
					if (m_bQuit) continue;
				}
				// DrawSceneĂяoA`ł(surface)
				// pӂ̂́A[U[̐ӔC
				yET.WaitFrame(); // t[\Ń^C~O
				yDD.DrawScreen();
			}
		}
		if (m_bPaused){
			// AvANeBułȂ΁A
			// GetMessageɐ؂ւĕׂ炷
			GetMessage(&msg,NULL,0,0); // ɂAقڂOɂł͂
			goto TransMes;
		}
	}

	//	WindowbZ[W̃tbNI
	MsgUnhook(); // WM_QUITŔĂ͂
}

//////////////////////////////////////////////////////////////////////////////
void CGameFrame::SetNextScene(void pFunc(int)){ // ֐|C^Ƃ֐
//	SetSceneQ[ÍAKfXgN^Ăяo邱Ƃۏ؂
// iCallScene͌ĂяoȂj
	if (DrawScene!=NULL) DrawScene(2); // ScenefXgN^ďo

	DrawScene = pFunc;
	m_bFirstDraw = true;
}

void CGameFrame::CallScene(void pFunc(int)){ // ֐|C^Ƃ֐
	DrawScene(4); // Scene Call Destructor
	m_SceneArray.push_back(DrawScene); // pusĥ:p

	DrawScene = pFunc;
	m_bFirstDraw = true;
}

void CGameFrame::ReturnScene(void){
	// Return̎́AScenefXgN^ĂяoB
	DrawScene(2); // fXgN^
	if (m_SceneArray.empty()) {
		//	InnerLog("ReturnSceneŖ߂ꏊ(CallSceneĂȂH)");
		Quit();	//	قȁAł܂ˁI
		return ;
	}
	DrawScene = m_SceneArray.back();
	m_SceneArray.pop_back();
	DrawScene(3); // Scene Call Constructor
	
//	m_bFirstDraw = true;
// @@returnƂ́ÃV[̃RXgN^ĂяoȂ
//		RXgN^QĂяoƂɂȂ邽߁j
//		 ꂪȂ΁ACallScenêƂɁÃfXgN^
//		ĂяoĂƂɂȂ邪AꂾCallĂӖȂȂB
//		 āA͎dlƂB

}

void CGameFrame::DestructScene(void){
	if (DrawScene!=NULL) DrawScene(2);	  // ݂ScenefXgN^ďo

	// CallSceneŌĂ΂ĂV[̃fXgN^ďo
	for(int i=m_SceneArray.size()-1;i>=0;i--){
		// SceneArray̓X^bNIɎgpĂ̂ŋtŃfXgNg
		//	ĩ[v̏́Aƃ_Tcj
		m_SceneArray[i](2); // fXgN^ďoII
	}
}

//////////////////////////////////////////////////////////////////////////////

void CGameFrame::Quit(void){	// Î[II
	if (m_hWnd!=NULL) {
		PostMessage(m_hWnd,WM_CLOSE,0,0);
	}
	m_bQuit = true;
}

void CGameFrame::SetGameExit(LRESULT pFunc(void)){
	GameExit = pFunc;
}

void CGameFrame::MessageOut(string caption,string message){
	// tXN[ŃtbvgĂ邩mȂ̂
	yDD.FlipToGDISurface();
	yDD.ShowCursor(true);	// \tgEFA}EXJ[\s
	MessageBox(m_hWnd,message.c_str(),caption.c_str(),MB_OK|MB_SYSTEMMODAL|MB_SETFOREGROUND);
}

bool CGameFrame::YesNo(string caption,string message){

	// tXN[ŃtbvgĂ邩mȂ̂
	yDD.FlipToGDISurface();
	yDD.ShowCursor(true);	// \tgEFA}EXJ[\s

	int h = MessageBox(m_hWnd,message.c_str(),caption.c_str(),MB_YESNO|MB_SYSTEMMODAL);
	if (h==IDYES) {
		return true;
	} else {
		return false;
	}
}

LRESULT CGameFrame::SetAppName(LPSTR Name)
{
	m_AppName = Name;

	// EBhD̃LvVς
	if (SetWindowText(m_hWnd,Name)) return 0; else return 1;
}

void CGameFrame::SetMultiApp(bool bEnable){
	m_bMultiApp = bEnable;
}

void CGameFrame::SetPauseUse(bool bEnable){
	m_bUsePause = bEnable;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CGameFrame::WndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	if (hWnd!=m_hWnd) return 0; // Ƃ̂ƂႤI
	
	// ALTƂQ[ŎgŃL[bZ[W͏Ȃ
	if ( WM_KEYFIRST<=iMsg && iMsg<=WM_KEYLAST) return 1;

	switch(iMsg){
	case WM_ACTIVATEAPP: {
		// 䂪ÃAvɂȂ΁AbZ[W[vPause|B
		if (!m_bUsePause) return 0; // 䂪̃EBhDɈڂƂPauseȂ^CvH

		UINT bActive = wParam;
		if (bActive) { // 䂪̃AvɈڂIiDɂāj
		// ́ÃEBhDɃtH[JXڂƂɃQ[~
		// 悤ȎdlɂĂBRgAEg΁AÂB
			if (m_bPaused) {
			//	ɍĊJłȂReplay
				m_bPaused = false;
				m_bGamePaused = false;		//	Q[Xbh̍ĊJ
				CGameTime::RestartTimeAll();//	GameTimeRestart
			}
		} else {
			// 䂪ꂽ(Dɂ)
			//	Ɏ~܂鏇Pause
			m_bPaused = true;
			m_bGamePaused = true;			//	Q[Xbh̒~
			CGameTime::PauseTimeAll();		//	GameTimePause
		}
		return 0;
	}

	case WM_CLOSE: { // EChEꂽ
	// I[U[`ĂȂ
		if (GameExit!=NULL) { // [U[̏I֐
			if (GameExit()) {
				m_bQuit = false;
				return 1; // ςIȂ񂾂āI
			}
		}
		// I邱Ƃm肵
		DestructScene(); // CallSceneŌĂ΂ĂV[̃fXgN^ďo
		
		//	EBhDĵƂŏAj[VsȂA
		//	悻Ɉڂ̂ŁAAvIĂ̂ɋ̔
		//	^XNo[ɕ\ꂽ܂܂ɂȂ

		ShowWindow(hWnd,SW_HIDE);

		Terminate(); // DirectX܂̏I

		// ́AfBtHgbZ[WnhWM_CLOSE
		// 󂯎DestroyWindowOɎsĂKvB
		DestroyWindow(m_hWnd);
		return 1;
					}

	case WM_DESTROY:{
	// {ȂWM_CLOSEDestroyWindowWM_DESTROYPostQuitMessageWM_QUIT
	// ƂŁAAvI
		PostQuitMessage(0);
		return 1;
					}
	
	case WM_SIZE:	//	@{^ɂő剻...
		if (wParam==SIZE_MAXIMIZED) {
			ysDraw.SetDisplayMode(FullScreenMode);
			return 0;
		}
		return 0;
	}
	return 0; // DefWindowProcĂяo
}

//////////////////////////////////////////////////////////////////////////////
