// yaneGameFrame.h

#ifndef __yaneGameFrame_H__
#define __yaneGameFrame_H__

#include <vector>				//	STL
#include <string>				//	STL
using namespace std;

#include "yaneDirectDraw.h"		//	DirectDraw  wrapper
#include "yaneDirectInput.h"	//	DirectInput wrapper
#include "yaneElapseTime.h"		//	for FPS
#include "yaneGameTime.h"		//  timeBeginPeriod`timeEndPeriod
#include "yaneError.h"			//	for ErrorLog
#include "yaneMutex.h"			//	QdNh~p
#include "yaneWinHook.h"		//	Window Message Hooker

typedef vector<void (*)(int)> CSceneArray;

//	yaneurao GameSDK framework
//	programmed by yaneurao(M.Isozaki)

class CGameFrame :public CWinHook {
public:
	// [U[ṕׂAȉ̂
	CDirectDraw	 yDD;
	CDirectInput yDI;
	CElapseTime	 yET;

	void	SetNextScene(void pFunc(int));				// ̃V[ݒ肷
	void	CallScene(void pFunc(int));					// V[ݒicallj
	void	ReturnScene(void);							// CallSceneŌĂяoÕV[ɖ߂
	void	Quit(void);									// ĂяoƏÎ

	void	SetGameExit(LRESULT pFunc(void));			// IɌĂяo֐̐ݒ
	void	MessageOut(string caption,string message);	// MessageBoxŃbZ[W\
	bool	YesNo(string caption,string message);		// [U[Yes,No₢킹B
	LRESULT	SetAppName(LPSTR Name);						// Av̐ݒ(Captionɔf)
	void	SetMultiApp(bool bEnable);					// N̂
	void	SetPauseUse(bool bEnable);					// Avɐ䂪ڂƂPause|̂H

//////////////////////////////////////////////////////////////////////////////
public:
	CGameFrame();
	~CGameFrame();

	LRESULT Start(HINSTANCE hInst,LPSTR lpCmdParam,int nCmdShow); // X^[gI
//////////////////////////////////////////////////////////////////////////////
protected:
	HINSTANCE	m_hInst;
	HWND		m_hWnd;
	char		m_CmdParam[_MAX_PATH];	//	lpCmdParam
	int			m_nCmdShow;			//	nCmdShow
	string		m_AppName;			//	AṽLvV
	bool		m_bMultiApp;		//	Av̓N̂H
	bool		m_bGamePaused;		//	݁AQ[Xbh~Ă̂H
	bool		m_bPaused;			//	݁ÃAv̓ANeBuȂ̂H
	bool		m_bUsePause;		//	ANeBuɂȂƂPauseH
	yaneMutex	*m_yaneMutex;		//	QdNh~p
	string		m_lpszMutexName;	//	QdNh~pMutex
	bool		m_bQuit;			//	Ip	
//////////////////////////////////////////////////////////////////////////////
	void		(*DrawScene)(int);	//@[U[̕`֐
	bool		m_bFirstDraw;		//	̃V[̈ꔭڂ̏Ȃtrue
	LRESULT		(*GameExit)(void);	//	Q[ĨR[obN֐
	void		DestructScene(void); //	V[fXgN^
	CSceneArray m_SceneArray;		//	CallSceneł̌ďo
//////////////////////////////////////////////////////////////////////////////
	LRESULT		Initialize(void);
	LRESULT		Terminate(void);
	void		MessageLoop(void);	// bZ[W
	LRESULT		WndProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

};	// Ȃɂ܂Ƃ܂ĂŁA܂ǂƂ悤

//////////////////////////////////////////////////////////////////////////////

extern CGameFrame		TheSDK;

//	gĂ[
extern CGameFrame&		ysFrame;
extern CDirectDraw&		ysDraw;
extern CDirectInput&	ysInput;
extern CGameWindow&		ysWindow;
extern CElapseTime&		ysTime;
#define ysWindow (*ysDraw.GetGameWindow())

//////////////////////////////////////////////////////////////////////////////

#endif
