// yaneLayer.cpp
//

#include <algorithm>			//	STL for remove

#include "yaneLayer.h"
#include "yaneGameFrame.h"	// ysDraw

CLayerScreen LayerScreen;

//////////////////////////////////////////////////////////////////////////////
void CLayer::BltScreen(void){
	for(int i=0;i<LayerScreen.size();i++){
		if (!LayerScreen[i]->m_bHDC && !LayerScreen[i]->m_bMouse) {
			LayerScreen[i]->OnPaint(); // ׂČĂяô:p
		}
	}
}

void CLayer::BltHDCScreen(HDC hdc){
	for(int i=0;i<LayerScreen.size();i++){
		if (LayerScreen[i]->m_bHDC && !LayerScreen[i]->m_bMouse) {
			LayerScreen[i]->OnPaint(hdc); // ׂČĂяô:p
		}
	}
}

void CLayer::BltMouseScreen(void){
	//	MouseLayerpBlt
	for(int i=0;i<LayerScreen.size();i++){
		if (!LayerScreen[i]->m_bHDC && LayerScreen[i]->m_bMouse) {
			LayerScreen[i]->OnPaint(); // ׂČĂяô:p
		}
	}
}

//////////////////////////////////////////////////////////////////////////////
void CLayer::Move(int x,int y){
	m_x = x;
	m_y = y;
}

void CLayer::GetPos(int &x,int &y){
	x = m_x;
	y = m_y;
}

void CLayer::SetRate(double rx,double ry){
	m_rx = rx;
	if (ry<0) ry=rx;
	m_ry = ry;
}

void CLayer::GetRate(double &rx,double &ry){
	rx = m_rx;
	ry = m_ry;
}

void CLayer::OnPaint(void) {
	// [BhNXŃI[o[Ch...
	// éA(m_x,m_y)̈ʒuɃC̍オ悤ɕ`悵炦
}

void CLayer::OnPaint(HDC) {
	// [BhNXŃI[o[Ch...
	// éA(m_x,m_y)̈ʒuɃC̍オ悤ɕ`悵炦
}

CLayer::CLayer(void) {
	m_x = m_y = 0;	// ɂƂ...
	m_bHDC = false;
	m_bInstalled = false;
	m_bMouse = false;
}

CLayer::~CLayer(){
	// YƂ炠񂳂
	if (m_bInstalled) LayerScreen -= this; // ̃|C^\Xg疕Ƃ
}

//////////////////////////////////////////////////////////////////////////////
CLayerScreen::CLayerScreen(void){
	m_bFirst = true;
	m_nHDCLayer = 0;
}

CLayerPtrArray& CLayerScreen::operator =  (CLayer *layer){
	for(;;) {
		if (LayerScreen.empty()) break;
		*this -= (*this)[0];	// -= operatorgpĈÂ
	}

	// initializeiÔ߁j
	m_nHDCLayer = 0;
	typedef void(*HDCFUNC)(HDC);	// for VC++5.0's bug
	vector<HDCFUNC>::iterator it;
	it = remove(ysDraw.m_BltHDCScreenList.begin()
			,ysDraw.m_BltHDCScreenList.end()
			,(CLayer::BltHDCScreen));
	ysDraw.m_BltHDCScreenList.resize(it - ysDraw.m_BltHDCScreenList.begin());	//	removeASYɂ͕KresizeKv

	if (layer!=NULL) *this += layer;
	return *this;
}

CLayerPtrArray& CLayerScreen::operator += (CLayer *layer){
	if (layer->IsInstalled()) return *this;	// Installς݁H

	if (m_bFirst) {
		m_bFirst = false;
		//	蔲BƂɂ͂ǂȂ:p
		ysDraw.m_BltScreenList.push_back(CLayer::BltScreen);
		ysDraw.m_BltMouseScreenList.push_back(CLayer::BltMouseScreen);
	}

	if (layer->GetHDCPaint()) {
		if(m_nHDCLayer==0) ysDraw.m_BltHDCScreenList.push_back(CLayer::BltHDCScreen);
		m_nHDCLayer++;	// Qƃ|C^̉Z
	}
	
	this->push_back(layer); // ̃|C^\Xgɒǉ
	// install!!
	layer->SetInstalled(true);

	return *this;
}

CLayerPtrArray& CLayerScreen::operator -= (CLayer *layer){
	if (!layer->IsInstalled()) return *this;	// InstallĂȂȂΖ

	//	HDCrh̐
	if (layer->GetHDCPaint()) {
		m_nHDCLayer--;
		if(m_nHDCLayer==0) {
			typedef void(*HDCFUNC)(HDC);	// for VC++5.0's bug
			vector<HDCFUNC>::iterator it;
			it = remove(ysDraw.m_BltHDCScreenList.begin(),
				ysDraw.m_BltHDCScreenList.end(),
				CLayer::BltHDCScreen);
			ysDraw.m_BltHDCScreenList.resize(it - ysDraw.m_BltHDCScreenList.begin());	//	removeASYɂ͕KresizeKv
		}
	}

	vector<CLayer*>::iterator it;
	it = remove(this->begin(),this->end(),layer);
	this->resize(it - this->begin());	//	removeASYɂ͕KresizeKv
	// uninstall!!
	layer->SetInstalled(false);

	return *this;
}

//	Ε֗̂قH
CLayerPtrArray& CLayerScreen::operator =	(CLayer &layer){ return *this = &layer; }
CLayerPtrArray& CLayerScreen::operator +=	(CLayer &layer){ return *this += &layer; }
CLayerPtrArray& CLayerScreen::operator -=	(CLayer &layer){ return *this -= &layer; }

//////////////////////////////////////////////////////////////////////////////
// ZJ_obt@NA邾̃C
void CClearLayer::OnPaint(void) { ysDraw.ClearSecondary(); }
CClearLayer ClearLayer;
