#include "yaneMapLayer.h"
#include "yaneMacro.h"

void	CMapLayer::SetMapChipSize(int x,int y){
	// }bv`bṽTCYݒ
	m_nMapCX = x;
	m_nMapCY = y;
}

void	CMapLayer::SetMapSize(int x,int y){
	// }bvŜ̃TCYݒ
	DELETE_SAFE(m_MapData);
	m_MapData = new WORD[x*y];
	m_nMapX = x;
	m_nMapY = y;

	for(int j=0;j<y;j++){
		for(int i=0;i<x;i++){
			m_MapData[i + j*x] = -1;	// -1ŏ
		}
	}
}

void	CMapLayer::SetMapBank(CPlane *plane){
		// }bvpoN̐ݒ
	m_lpMapPlane = plane;
}

void	CMapLayer::SetMapChip(int x,int y,WORD mapchip){
	if (m_MapData==NULL) return ; // Mapf[^mۂĂȂ...
	// }bv`bvzuB

	if (x<0 || x>=m_nMapX || y<0 || y>=m_nMapY) return ; // ͈͊OȂ̂
	*(m_MapData + x + m_nMapX * y) = mapchip;
}

void	CMapLayer::GetMapArea(int &x,int &y){
	x = m_nMapX * m_nMapCX;
	y = m_nMapY * m_nMapCY;
}

void	CMapLayer::ResizeMap(int x,int y){
	// oA܂̃}bvăTCYύXB
	WORD *lpdwData = new WORD[x*y];

	for(int j=0;j<y;j++){
		for(int i=0;i<x;i++){
			if (i<m_nMapX && j<m_nMapY) {
				lpdwData[i + j*x] = m_MapData[i + j*x];
			} else {
				m_MapData[i + j*x] = -1;	// -1ŏ
			}
		}
	}

	DELETE_SAFE(m_MapData);
	m_MapData = lpdwData;	// |C^ւI
	m_nMapX = x;			// TCYꂽTCY𔽉f
	m_nMapY = y;
}

void	CMapLayer::OnPaint(void){
	if (m_lpMapPlane==NULL) return ; // ܂ݒ肳Ă炸
	// CLayer::m_x,CLayer::m_yɏ]ĕ\B

	int scx,scy;	// XN[TCY擾
	ysDraw.GetScreenSize(scx,scy);	// ̕\

	// }bv`bvʒuZo
	int MX,MY,SX;	// }bv`bvԍ̎Zo
	SX = m_x / m_nMapCX;
	MY = m_y / m_nMapCY;

	RECT r;
	WORD chip,cx,cy;

	// [}CiXn߂̂i|pIHj
	for(int y = -(m_y % m_nMapCY) ; y<scy ; y+=m_nMapCY){
		MX = SX;
		for(int x = -(m_x % m_nMapCX) ; x<scx ; x+=m_nMapCX){
			if (MX>=0 && MX<m_nMapX && MY>=0 && MY<m_nMapY){
				if ((chip = m_MapData[MX + MY*m_nMapX])!=-1){ // -1ȂΔzuĂȂ
					cx = (chip & 0xff)*m_nMapCX;	// 8rbg}bv`bv̂wW
					cy = (chip >> 8  )*m_nMapCY;
					SetRect(&r,cx,cy,cx+m_nMapCX,cy+m_nMapCY);
					m_lpMapPlane->BltFast(x,y,r);
				}
			}
			MX++;
		}
		MY ++;
	}
}

void	CMapLayer::OnPaintBlt(void){
	if (m_lpMapPlane==NULL) return ; // ܂ݒ肳Ă炸
	// CLayer::m_x,CLayer::m_yɏ]ĕ\B

	int scx,scy;	// XN[TCY擾
	ysDraw.GetScreenSize(scx,scy);	// ̕\

	// }bv`bvʒuZo
	int MX,MY,SX;	// }bv`bvԍ̎Zo
	SX = m_x / m_nMapCX;
	MY = m_y / m_nMapCY;

	RECT r;
	WORD chip,cx,cy;

	// [}CiXn߂̂i|pIHj
	for(int y = -(m_y % m_nMapCY) ; y<scy ; y+=m_nMapCY){
		MX = SX;
		for(int x = -(m_x % m_nMapCX) ; x<scx ; x+=m_nMapCX){
			if (MX>=0 && MX<m_nMapX && MY>=0 && MY<m_nMapY){
				if ((chip = m_MapData[MX + MY*m_nMapX])!=-1){ // -1ȂΔzuĂȂ
					cx = (chip & 0xff)*m_nMapCX;	// 8rbg}bv`bv̂wW
					cy = (chip >> 8  )*m_nMapCY;
					SetRect(&r,cx,cy,cx+m_nMapCX,cy+m_nMapCY);
					m_lpMapPlane->Blt(x,y,r);
				}
			}
			MX++;
		}
		MY ++;
	}
}

CMapLayer::CMapLayer(void){
	m_lpMapPlane = NULL;
	m_nMapX	  = m_nMapY	  = 0;
	m_nMapCX  = m_nMapCY  = 1;	// OG[oVȂ̂Łi΁j
	m_MapData = NULL;
}

CMapLayer::~CMapLayer(){
	DELETE_SAFE(m_MapData);
}
