#include "yaneMapLayer2.h"
#include "yaneMacro.h"

void	CMapLayer2::SetMapChipSize(int x,int y){
	// }bv`bṽTCYݒ
	m_nMapCX = x;
	m_nMapCY = y;
}

void	CMapLayer2::SetMapSize(int x,int y){
	// }bvŜ̃TCYݒ
	DELETE_SAFE(m_MapData);
	m_MapData = new CMapChip[x*y];	//	RXgN^ďĂĂ͂
	m_nMapX = x;
	m_nMapY = y;
}

void	CMapLayer2::GetMapSize(int &x,int &y){
	x = m_nMapX;
	y = m_nMapY;
}

void	CMapLayer2::SetMapBank(CPlane *plane){
		// }bvpoN̐ݒ
	m_lpMapPlane = plane;
}

CPlane*	CMapLayer2::GetMapBank(void){
		//	}bvv[ւ̃|C^𓾂
	return m_lpMapPlane;
}

CMapChip*	CMapLayer2::GetMapChip(int x,int y){
	if (x<0 || y<0 || x>=m_nMapX || y>=m_nMapY) return NULL;
	return m_MapData + x + m_nMapX * y;
}

void	CMapLayer2::GetMapArea(int &x,int &y){
	//	}bvŜ̃hbg𓾂
	x = m_nMapX * m_nMapCX;
	y = m_nMapY * m_nMapCY;
}

void	CMapLayer2::ResizeMap(int x,int y){
	// oA܂̃}bvăTCYύXB
	CMapChip* lpdwData = new CMapChip[x*y];

	for(int j=0;j<y;j++){
		for(int i=0;i<x;i++){
			if (i<m_nMapX && j<m_nMapY) {
				lpdwData[i + j*x] = m_MapData[i + j*x];
			}
		}
	}

	DELETE_SAFE(m_MapData);
	m_MapData = lpdwData;	// |C^ւI
	m_nMapX = x;			// TCYꂽTCY𔽉f
	m_nMapY = y;
}

//////////////////////////////////////////////////////////////////////////////
void	CMapLayer2::OnPaint(void){
	OnPaint1();		//	C
	OnPaint2();		//	C
	OnPaint3();		//	ヌC
	OnPaint4();		//	C
}
//////////////////////////////////////////////////////////////////////////////

void	CMapLayer2::OnPaint1(void){
	if (m_lpMapPlane==NULL) return ; // ܂ݒ肳Ă炸
	// CLayer::m_x,CLayer::m_yɏ]ĕ\B

	int scx,scy;	// XN[TCY擾
	ysDraw.GetScreenSize(scx,scy);	// ̕\

	// }bv`bvʒuZo
	int MX,MY,SX;	// }bv`bvԍ̎Zo

	//	}CiX̏ꍇA܂Ã`FbN͂Ă̂ō\Ȃ
	SX = m_x / m_nMapCX;
	MY = m_y / m_nMapCY;

	RECT r;
	WORD chip,cx,cy;

	int x,y;
	// [}CiXn߂̂i|pIHj
	for(y = -(m_y % m_nMapCY) ; y<scy ; y+=m_nMapCY){
		MX = SX;
		for(x = -(m_x % m_nMapCX) ; x<scx ; x+=m_nMapCX){
			if (MX>=0 && MX<m_nMapX && MY>=0 && MY<m_nMapY){
				if ((chip = m_MapData[MX + MY*m_nMapX].chip1a)!=65535){ // -1ȂΔzuĂȂ
					cx = (chip & 0xff)*m_nMapCX;	// 8rbg}bv`bv̂wW
					cy = (chip >> 8	 )*m_nMapCY;
					SetRect(&r,cx,cy,cx+m_nMapCX,cy+m_nMapCY);
					m_lpMapPlane->BltFast(x,y,r);
				}
			}
			MX++;
		}
		MY ++;
	}
}

void	CMapLayer2::OnPaint2(void){
	if (m_lpMapPlane==NULL) return ; // ܂ݒ肳Ă炸
	// CLayer::m_x,CLayer::m_yɏ]ĕ\B

	int scx,scy;	// XN[TCY擾
	ysDraw.GetScreenSize(scx,scy);	// ̕\

	// }bv`bvʒuZo
	int MX,MY,SX;	// }bv`bvԍ̎Zo

	//	}CiX̏ꍇA܂Ã`FbN͂Ă̂ō\Ȃ
	SX = m_x / m_nMapCX;
	MY = m_y / m_nMapCY;

	RECT r;
	WORD chip,cx,cy;

	int x,y;
	int i;

	//	L\́ACƍĕ\sȂ˂΂ȂȂ...		

	//	LÃ݂XN[WɈړ
	for(i=0;i<m_nMapChara;i++){
		m_MapChara[i].x -= m_x;
		m_MapChara[i].y -= m_y;
		m_MapChara[i].height -= m_nMapCY;	//	ʒu␳
	}
	//	LÃ݂XN[WɈړ
	for(i=0;i<m_nMapChara2;i++){
		m_MapChara2[i].x -= m_x;
		m_MapChara2[i].y -= m_y;
		m_MapChara2[i].height -= m_nMapCY;	//	ʒu␳
	}

	//	ʏɂƂ̂߂...
	y = -(m_y % m_nMapCY);
	for(i=0;i<m_nMapChara2;i++){
		int cry = m_MapChara2[i].y+ m_MapChara2[i].height;
		y = -(m_y % m_nMapCY);
		if (cry <= y) {
			m_MapChara2[i].plane->Blt(m_MapChara2[i].x,m_MapChara2[i].y,m_MapChara2[i].sr);
		}
	}
	for(i=0;i<m_nMapChara;i++){
		int cry = m_MapChara[i].y+ m_MapChara[i].height;
		y = -(m_y % m_nMapCY);
		if (cry <= y) {
			m_MapChara[i].plane->Blt(m_MapChara[i].x,m_MapChara[i].y,m_MapChara[i].sr);
		}
	}
	
	for(y = -(m_y % m_nMapCY) ; y<scy ; y+=m_nMapCY){
		MX = SX;
		
		for(x = -(m_x % m_nMapCX) ; x<scx ; x+=m_nMapCX){
			if (MX>=0 && MX<m_nMapX && MY>=0 && MY<m_nMapY){
				if ((chip = m_MapData[MX + MY*m_nMapX].chip2a)!=65535){ // -1ȂΔzuĂȂ
					cx = (chip & 0xff)*m_nMapCX;	// 8rbg}bv`bv̂wW
					cy = (chip >> 8	 )*m_nMapCY;
					SetRect(&r,cx,cy,cx+m_nMapCX,cy+m_nMapCY);
					m_lpMapPlane->Blt(x,y,r);
				}
			}
			MX++;
		}
		//	L\i蔲uhMix:pj
		//	{́A炩߃\[gƂׂȂȂ...
		for(i=0;i<m_nMapChara2;i++){
			int cry = m_MapChara2[i].y+ m_MapChara2[i].height;
			if ((y < cry) && (cry <= y+m_nMapCY)) {
				m_MapChara2[i].plane->Blt(m_MapChara2[i].x,m_MapChara2[i].y,m_MapChara2[i].sr);
			}
		}
		for(i=0;i<m_nMapChara;i++){
			int cry = m_MapChara[i].y+ m_MapChara[i].height;
			if ((y < cry) && (cry <= y+m_nMapCY)) {
				m_MapChara[i].plane->Blt(m_MapChara[i].x,m_MapChara[i].y,m_MapChara[i].sr);
			}
		}
		MY ++;
	}
}


void	CMapLayer2::OnPaint3(void){
	if (m_lpMapPlane==NULL) return ; // ܂ݒ肳Ă炸
	// CLayer::m_x,CLayer::m_yɏ]ĕ\B

	int scx,scy;	// XN[TCY擾
	ysDraw.GetScreenSize(scx,scy);	// ̕\

	// }bv`bvʒuZo
	int MX,MY,SX;	// }bv`bvԍ̎Zo

	//	}CiX̏ꍇA܂Ã`FbN͂Ă̂ō\Ȃ
	SX = m_x / m_nMapCX;
	MY = m_y / m_nMapCY;

	RECT r;
	WORD chip,cx,cy;

	int x,y;
	//	ヌC

	for(y = -(m_y % m_nMapCY) ; y<scy ; y+=m_nMapCY){
		MX = SX;
		for(x = -(m_x % m_nMapCX) ; x<scx ; x+=m_nMapCX){
			if (MX>=0 && MX<m_nMapX && MY>=0 && MY<m_nMapY){
				if ((chip = m_MapData[MX + MY*m_nMapX].chip3a)!=65535){ // -1ȂΔzuĂȂ
					cx = (chip & 0xff)*m_nMapCX;	// 8rbg}bv`bv̂wW
					cy = (chip >> 8	 )*m_nMapCY;
					SetRect(&r,cx,cy,cx+m_nMapCX,cy+m_nMapCY);
					m_lpMapPlane->Blt(x,y,r);
				}
			}
			MX++;
		}
		MY ++;
	}
}

void	CMapLayer2::OnPaint4(void){
	//	IC
	for(int i=0;i<m_nMapChara3;i++){
		m_MapChara3[i].plane->Blt(m_MapChara3[i].x-m_x,m_MapChara3[i].y-m_y,m_MapChara3[i].sr);
	}
}

//////////////////////////////////////////////////////////////////////////////

CMapLayer2::CMapLayer2(void){
	m_lpMapPlane = NULL;
	m_nMapX	  = m_nMapY	  = 0;
	m_nMapCX  = m_nMapCY  = 1;	// OG[oVȂ̂Łi΁j
	m_MapData = NULL;

	m_nMapChara		= 0;
	m_nMapChara2	= 0;
}

CMapLayer2::~CMapLayer2(){
	DELETE_SAFE(m_MapData);
}
