//	yanePlane.cpp

#include "yanePlane.h"
#include "yaneFile.h"
#include "yaneMacro.h"
#include "yaneError.h"

//////////////////////////////////////////////////////////////////////////////

CPlanePtrArray CPlane::m_lpaPlane;

// ݃ACYĂpbg
CPlane* CPlane::m_lpPalettePlaneNow = NULL;

//////////////////////////////////////////////////////////////////////////////

CPlane::CPlane(void) {
	m_lpSurface		= NULL;
	m_lpPalette		= NULL;
	m_nPlaneXSize	= 0;
	m_nPlaneYSize	= 0;
	EnableBlendColorKey(false);
	m_ColorKey		= 0;
	m_cx = m_cy = 0;
	m_bUseBlendColorKey = false;
	m_bLoadPalette	= true;
	m_hdc			= NULL;
	m_bBitmapW		= false;
	m_bOwnerDraw	= false;	// ʏ́AI[i[h[ł͂Ȃ

	m_lpaPlane.insert(this); // ̃CX^X`FCɒǉ

	//	łĂ[ĂȁH
	ZERO(m_ddbltfx);
	m_ddbltfx.dwSize = sizeof(DDBLTFX);
}

CPlane::~CPlane(){
	RELEASE_SAFE(m_lpSurface);
	RELEASE_SAFE(m_lpPalette);

	m_lpaPlane.erase(this);	// ̃CX^X`FC폜

	// ̃v[̃pbgACŶɎgĂȂΉĂ
	if (m_lpPalettePlaneNow == this) {
		m_lpPalettePlaneNow = NULL;
	}
}

//////////////////////////////////////////////////////////////////////////////

LPDIRECTDRAWSURFACE CPlane::GetSurface(void){
	return m_lpSurface;
}

LPDIRECTDRAWPALETTE CPlane::GetPalette(void){
	return m_lpPalette;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CPlane::LoadBitmapFile(string BitmapFileName,bool bLoadPalette){
	m_bBitmapW = false;

	m_DirectDrawBitmapFile = BitmapFileName;
	// ƂRestoreł悤Ƀt@Ci[ĂB

	return LoadBitmapFile2(BitmapFileName,bLoadPalette);
}

LRESULT CPlane::LoadBitmapFileW(string BitmapFileName256,string BitmapFileNameElse,bool bLoadPalette){
	m_bBitmapW = true;
	
	m_DirectDrawBitmapFile	= BitmapFileName256;		// 256F
	m_DirectDrawBitmapFile2	= BitmapFileNameElse;		// 256F
	// ƂRestoreł悤Ƀt@Ci[ĂB

	if (GetBpp()==8) {
		return LoadBitmapFile2(BitmapFileName256,bLoadPalette);
	} else {
		return LoadBitmapFile2(BitmapFileNameElse,bLoadPalette);
	}
}

LRESULT CPlane::LoadBitmapFile2(string BitmapFileName,bool bLoadPalette){
	// IɎgpĂ̂ŁArbg}bvt@C͕ۑȂB

	if (CDirectDraw::m_lpDirectDraw==NULL) {
		InnerLog("CPlane::LoadBitmapCDirectDraw::m_lpDirectDraw==NULL");
		return 1; // ߂
	}

	if (BitmapFileName.empty()) return 0; // ȂŁ`

	// rbg}bvt@Cl[̊Ǘ́Å֐͈؍sȂȂ
	ReleaseBuffer();
	
	// BitmapHeaderQƂēTCYSurfaceoB
	CYFile file;
	if (file.ReadFile(BitmapFileName.c_str())) {
		InnerLog("CPlane::LoadBitmapFileœǂݍރt@C >"+BitmapFileName);
		return 2; // t@CȂ
	}

	// ŁAt@C܂邲Ɠǂݍ߂
	// Ƃ́AfilesizefileadrŊ撣̂B
	BITMAPFILEHEADER *BF = (BITMAPFILEHEADER*)file.GetFileMemory();
	if (file.GetFileSize() < sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER) ||
			BF->bfType!=0x4D42) { // BMƂBMPƂႤłȂ
		InnerLog("LoadPlaneBitmapȊÕt@Cǂ");
		return 2;
	}
	BITMAPINFOHEADER *BI = (BITMAPINFOHEADER*)((BYTE*)file.GetFileMemory() + sizeof(BITMAPFILEHEADER));

	DDSURFACEDESC ddsd;
	ZERO(ddsd);
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;

	// TCYۑĂ
	m_nPlaneXSize = ddsd.dwWidth  = BI->biWidth;
	m_nPlaneYSize = ddsd.dwHeight = BI->biHeight;

	if (CDirectDraw::m_lpDirectDraw->CreateSurface(&ddsd,&m_lpSurface,NULL)!=DD_OK){
		InnerLog("CPlane::LoadBitmapFileCreateSurfaceɎs");
		return 3; // [
	}

	BYTE* lpBits; // sNZf[^̃AhX
	lpBits = (BYTE*)file.GetFileMemory() + BF->bfOffBits;
	// BitmapFileHeaderȂAŎZoł͂Ȃ̂H

	// but...pbg̏uYĂ͂ȂII
	// ꂪ߂炵i΁j

	// bLoadPalette == truȅꍇ
	//	 1.256F[hA2/16/256Frbg}bvȂ΁Apbg擾āA
	//	  OŃ[h
	//	 2.256F[hAFrbg}bvȂASetDIBitsToDeviceŃ[h
	//	({́AtF[hAEĝƂlƂ̂236ɌFׂ...)
	//	 3.ݔ256F[hȂ΁AȂłłSetDIBitsToDeviceŃ[h
	// bLoadPalette == falsȅꍇ
	//	 1.ȂłłSetDIBitsToDeviceŃ[h

	bool bUsePalette = false;
	m_bLoadPalette = bLoadPalette;

	if (bLoadPalette && BI->biBitCount <= 8 && GetBpp()==8) {
		// biBitCount == 1 or 4 or 8
		// ScreenColorMode2 == 8 (256Color)
		// fBXv[[h256F[hAǂݍރrbg}bv
		// pbggpĂꍇAOŃpbgČB
		bUsePalette = true;

		PALETTEENTRY pal[256];
		RGBQUAD *lpRGBquad;
		lpRGBquad = (RGBQUAD*) ((BYTE*) BI + sizeof(BITMAPINFOHEADER));

		DWORD dwFlags;
		int num;
		// ŏꏊ͂킩...
		switch (BI->biBitCount){
		case 1: dwFlags = DDPCAPS_1BIT; num = 2;   break;
		case 2: dwFlags = DDPCAPS_2BIT; num = 4;   break;
		case 4: dwFlags = DDPCAPS_4BIT; num = 16;  break;
		case 8: dwFlags = DDPCAPS_8BIT; num = 236; break; // 256͊ق:p
		default: dwFlags = 0;	// ˂񂯂ǂ
		} // Gg[𐔂...

		// ̎w͕sv
		// dwFlags |= DDPCAPS_ALLOW256;

		// ܂A236FpbgƂ̂́A0`235܂łgp̂łāA
		// 10`245͈̔͂ɃVtgĂKv
		
		// RGBQUADPALETTEENTRYƂłRBւI()	
		// ăoPʂł̃Rs[Kv

		// 0`9,246`255́AVXepbg(ÓIGg)
		for(int i=0;i<10;i++){
			pal[i].peFlags = PC_EXPLICIT; // ̃IvVƂƂɁA
			pal[i].peRed	= i; // VXepbgCfbNXw肷
			pal[i].peGreen	= 0;
			pal[i].peBlue	= 0;

			// 0`9,246`255̐F̑␫l΁AZł͂ȂxorقS
			pal[i ^ 0xff].peFlags = PC_EXPLICIT;
			pal[i ^ 0xff].peRed	   = i ^ 0xff;
			pal[i ^ 0xff].peGreen  = 0;
			pal[i ^ 0xff].peBlue   = 0;
		}

		// [U[pbg̐ݒ
		for(i=10;i<10+num;i++) {
			pal[i].peFlags = PC_NOCOLLAPSE | PC_RESERVED;
			// ̃AvɎgĂ͍邵AύXĂ
			pal[i].peRed   = lpRGBquad[i-10].rgbRed; // pbg̃Vtg
			pal[i].peGreen = lpRGBquad[i-10].rgbGreen;
			pal[i].peBlue  = lpRGBquad[i-10].rgbBlue;
		}

		for(;i<246;i++){ // ꉞA߂ƂH
			pal[i].peFlags = 0; // w肵Ȃ
			pal[i].peRed   = 0;
			pal[i].peGreen = 0;
			pal[i].peBlue  = 0;
		}

		if (CDirectDraw::m_lpDirectDraw->CreatePalette(dwFlags,pal,&m_lpPalette,NULL)!=DD_OK){
			InnerLog("CPlane::LoadBitmapFileŁACreatePaletteɎs");
			m_lpPalette = NULL;
			return 4;
		}
	}

	// 2,4,16FɑΉ邽߂ɉǂ('00/01/03)
	if (bUsePalette) {
		m_lpSurface->SetPalette(m_lpPalette);	//	pbgA^b`
	}
	HDC hDC;
	if (m_lpSurface->GetDC(&hDC)!=DD_OK) {
		InnerLog("CPlane::LoadBitmapFileGetDCɎs");
		if (bUsePalette) {
			m_lpSurface->SetPalette(NULL);	//	pbg̃f^b`
		}
		return 7;
	}
	// 256F[hőF\Ƃ́ApbgsĐݒ肵ĂȂ
	// AłȂȂ邪...
	if (SetDIBitsToDevice(hDC,0,0,BI->biWidth,BI->biHeight,0,0,0,BI->biHeight,
			(void*)lpBits,(BITMAPINFO*)BI,DIB_RGB_COLORS)==0) {
		InnerLog("CPlane::LoadBitmapFileSetDIBitsToDeviceɎs");
		m_lpSurface->ReleaseDC(hDC); // ܁[[Ȃ
		if (bUsePalette) {
			m_lpSurface->SetPalette(NULL);	//	pbg̃f^b`
		}
		return 8;
	}
	if (m_lpSurface->ReleaseDC(hDC)!=DD_OK){
		InnerLog("CPlane::LoadBitmapFileReleaseDCɎs");
		if (bUsePalette) {
			m_lpSurface->SetPalette(NULL);	//	pbg̃f^b`
		}
		return 9;
	}
	if (bUsePalette) {
		m_lpSurface->SetPalette(NULL);	//	pbg̃f^b`
	}


	if (m_bUsePosColorKey) {	// ʒuw^߃L[
		if (SetColorKey(m_cx,m_cy)) {
			InnerLog("CPlane::ʒuw^߃L[̐ݒɎs");
			return 0;	// G[Ƃ͂
		}
	} else {	// Fw^߃L[
	// fBtHgł́AƂ肠rgb = 0𓧉߃L[ƂĐݒ
	// isv̂ƂBltɓ߃L[𖳎̂gΗǂj
		if (SetColorKey(m_ColorKey)) {
			InnerLog("CPlane::Fw^߃L[̐ݒɎs");
			return 0;	// G[Ƃ͂
		}
	}

	return 0;
}

//////////////////////////////////////////////////////////////////////////////
LRESULT CPlane::SaveBitmapFile(LPSTR BitmapFileName){
	RECT	rc;
	SetRect(&rc,0,0,m_nPlaneXSize,m_nPlaneYSize);
	return SaveBitmapFile(BitmapFileName,rc);
}

LRESULT CPlane::SaveBitmapFile(LPSTR BitmapFileName,RECT& rc){
	if (CDirectDraw::m_lpDirectDraw==NULL) {
		InnerLog("CPlane::SaveBitmapFileCDirectDraw::m_lpDirectDraw==NULL");
		return 1;
	}
	if (m_lpSurface==NULL){
		InnerLog("CPlane::SaveBitmapFilem_lpSurface==NULL");
		return 2;
	}

	//	pbg炵AtJ[pɂāAHDC
	//	GetPixelœǂݍł܂H
	HDC hDC;
	if (m_lpSurface->GetDC(&hDC)!=DD_OK) {
		InnerLog("CPlane::SaveBitmapFileGetDCɎs");
		return 3;
	}

	//	rbg}bvm
	long lPitch = ((rc.right - rc.left)*3 + 3) & ~3;	// ꃉC̃oCg
	long size = sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER)
		+lPitch * (rc.bottom - rc.top);	//	ꂪ摜t@CTCYî͂j
	BYTE *bitmap =	new BYTE[size];

	//	rbg}bvwb_[̒`
	BITMAPFILEHEADER *BF = (BITMAPFILEHEADER*)bitmap;
	BF->bfType			= 0x4D42;
	BF->bfSize			= size;
	BF->bfReserved1		= 0;
	BF->bfReserved2		= 0;
	BF->bfOffBits		= sizeof(BITMAPFILEHEADER) + sizeof(BITMAPINFOHEADER);
	
	BITMAPINFOHEADER *BI = (BITMAPINFOHEADER*)((BYTE*)bitmap + sizeof(BITMAPFILEHEADER));
	BI->biSize			= sizeof(BITMAPINFOHEADER);
	BI->biWidth			= rc.right - rc.left;	// size to be saved...
	BI->biHeight		= rc.bottom - rc.top;
	BI->biPlanes		= 1;
	BI->biBitCount		= 24;		//	tJ[
	BI->biCompression	= 0;		//	񈳏k
	BI->biSizeImage		= 0;		//	񈳏k̂Ƃ0
	BI->biXPelsPerMeter	= 3780;	//	96dpi(ȂƂ댩Ă\tg͂Ȃ낤)
	BI->biYPelsPerMeter	= 3780;
	BI->biClrUsed		= 0;
	BI->biClrImportant	= 0;

	BYTE *image = (BYTE*)bitmap + sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER);

	//	C[W]ȂI
	int y2 = rc.bottom-rc.top-1;		//	㉺͔]Kv
	for(int y=rc.top;y<rc.bottom;y++,y2--){
		int x2 = 0;
		for(int x=rc.left;x<rc.right;x++,x2++){
			COLORREF c = GetPixel(hDC,x,y);
			*(image + x2*3 + y2*lPitch + 0) = GetBValue(c);
			*(image + x2*3 + y2*lPitch + 1) = GetGValue(c);
			*(image + x2*3 + y2*lPitch + 2) = GetRValue(c);
		}
	}

	if (m_lpSurface->ReleaseDC(hDC)!=DD_OK){
		InnerLog("CPlane::SaveBitmapFileReleaseDCɎs");
		return 5;
	}

	//	t@Cւ̏
	CYFile file;
	file.WriteFile(BitmapFileName,bitmap,size);	//	񂾂:p

	DELETEPTR_SAFE(bitmap);
	return 0;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CPlane::ReleaseBuffer(void){ // Buffer݂̂̉(Bitmapt@C͕ێ܂)
	RELEASE_SAFE(m_lpSurface);
	RELEASE_SAFE(m_lpPalette);
	return 0;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CPlane::Restore(void){	// lpDirectDrawBitmapFile[PlaneNo]ɏ]reload

	RELEASE_SAFE(m_lpSurface); // AĂ܂قĂƂ葁I
	//	ǂA𑜓x؂ւœ߃L[Ƃς\
	RELEASE_SAFE(m_lpPalette);

	if (m_bBitmapW) {
		if (GetBpp()==8) {	// 256F[hł͕ʂ̃t@C
			return LoadBitmapFile2(m_DirectDrawBitmapFile,m_bLoadPalette);
		} else {
			return LoadBitmapFile2(m_DirectDrawBitmapFile2,m_bLoadPalette);
		}
	} else {
		return LoadBitmapFile2(m_DirectDrawBitmapFile,m_bLoadPalette);
	}
}

//////////////////////////////////////////////////////////////////////////////

// gpĂrbg}bv̉
LRESULT CPlane::ReleaseBitmap(void){
	RELEASE_SAFE(m_lpPalette);
	RELEASE_SAFE(m_lpSurface);
	m_DirectDrawBitmapFile = "";
	m_DirectDrawBitmapFile2 = "";
	return 0;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CPlane::GetSize(int &x,int &y){
	if (this==NULL || m_lpSurface==NULL) {
		x = y = 0; // fail safe΍
		return 1;
	}
	x = m_nPlaneXSize;
	y = m_nPlaneYSize;
	return 0;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CPlane::SetColorKey(COLORREF rgb)
{
	if (m_lpSurface==NULL) return 1;

	DDCOLORKEY			ddck;

	ddck.dwColorSpaceLowValue  = DDColorMatch(m_lpSurface,rgb); // T[tF[X̂ǂ̓_ׂ
	ddck.dwColorSpaceHighValue = ddck.dwColorSpaceLowValue;

	m_bUsePosColorKey = false;
	m_ColorKey = rgb;	// ۑƂƕAłւ:p

	return m_lpSurface->SetColorKey(DDCKEY_SRCBLT, &ddck);
}

DWORD CPlane::DDColorMatch(LPDIRECTDRAWSURFACE pdds, COLORREF rgb)
{
	// ddutil.cppQlɂĂ͂邪ADirectDrawPalettéAGDIoRȂ
	// GDIGetPixelŉRԂĂ邱ƂB
	HDC hdc;
	DWORD dw = CLR_INVALID;
	DDSURFACEDESC ddsd;
	LRESULT hres;
	DWORD dwRGB;

	// QTUF[ĥ߂ɁA炩LOCKĒlۑ
	ddsd.dwSize = sizeof(ddsd);
	while ((hres = pdds->Lock(NULL, &ddsd, 0, NULL)) == DDERR_WASSTILLDRAWING)
	;

	if (hres == DD_OK) {
		dwRGB = *(DWORD *)ddsd.lpSurface;
		pdds->Unlock(NULL);
	}

	//	GDISetPixelāA𒼂LockēǂݍނƂŃpbg̊蓖ď󋵂m

	if (rgb != CLR_INVALID && pdds->GetDC(&hdc) == DD_OK){
		SetPixel(hdc, 0, 0, rgb);				// set our value
		pdds->ReleaseDC(hdc);
	}

	ddsd.dwSize = sizeof(ddsd);
	while ((hres = pdds->Lock(NULL, &ddsd, 0, NULL)) == DDERR_WASSTILLDRAWING)
	;

	if (hres == DD_OK) {
		dw	= *(DWORD *)ddsd.lpSurface;						// get DWORD
		if(ddsd.ddpfPixelFormat.dwRGBBitCount < 32)
			dw &= (1 << ddsd.ddpfPixelFormat.dwRGBBitCount)-1;	// mask it to bpp
		*(DWORD *)ddsd.lpSurface = dwRGB;
		pdds->Unlock(NULL);
	}

	return dw;
}

LRESULT CPlane::SetColorKey(int x,int y){	// (x,y)̓_𓧉߃L[ɐݒ肷
	if (m_lpSurface==NULL) return 1;

	DDCOLORKEY			ddck;

	ddck.dwColorSpaceLowValue  = DDGetPixel(m_lpSurface,x,y);
	ddck.dwColorSpaceHighValue = ddck.dwColorSpaceLowValue;

	m_bUsePosColorKey = true;
	m_cx = x;	// ۑƂƕAłւ
	m_cy = y;

	return m_lpSurface->SetColorKey(DDCKEY_SRCBLT, &ddck);
}

DWORD CPlane::DDGetPixel(LPDIRECTDRAWSURFACE pdds,int x,int y){ // ̓_̐F𒲂ׂ
	// SurfaceLock
	DDSURFACEDESC dddesc;
	ZERO(dddesc);
	dddesc.dwSize = sizeof(dddesc);
	if (pdds->Lock(NULL,&dddesc,
		DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL)!=DD_OK){
		InnerLog("CPlane::DDGetPixelSurfaceLockɎs");
		return CLR_INVALID;
	}

	//	Op̂Ŕ͈͊O`FbN܂Kv
	if (x<0 || x>=dddesc.dwWidth || y<0 || y>=dddesc.dwHeight){
		pdds->Unlock(NULL);
		return CLR_INVALID;
	}

	int bpp;
	bpp = dddesc.ddpfPixelFormat.dwRGBBitCount;

	void *p = dddesc.lpSurface;
	LONG lPitch	 = dddesc.lPitch;

	DWORD dw;
	switch (bpp) {
	case 8:
		dw = *((BYTE*)p + x + y * lPitch);
		break;
	case 16:
		dw = *(WORD*)((BYTE*)p + x*2 + y * lPitch);
		break;
	case 24:
		dw = *(DWORD*)((BYTE*)p + x*3 + y * lPitch) & 0xffffff;
		break;
	case 32:
		dw = *(DWORD*)((BYTE*)p + x*4 + y * lPitch);
		break;
	default:
		dw = 0; // unsupported!!
	}

	pdds->Unlock(NULL);

	return dw;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CPlane::Blt(int x,int y){
// RECTȂꍇÃv[܂邲ƃRs[Ȃ̂B
	RECT r;
	SetRect(&r,0,0,m_nPlaneXSize,m_nPlaneYSize);
	return Blt(x,y,r); // ̂܂܌ĂяôB
//	m_bDirty = true;
}

LRESULT CPlane::Blt(int x,int y,RECT r){
// `̓]BA̓]`͓_(r.right,r.bottom)͊܂܂ȂƂɒӁI
	
	if (CDirectDraw::m_lpSecondary==NULL) return -1; // ȂŁ[HH
	if (m_lpSurface==NULL) return -1; // [I
	// `Blt̂ClipperȂĂ炭[I
	// 蓮Clipف[ۂǑI(BltFastg邵)

	// Oœ]قDirectDrawClipperۂǑ

	// ]Rect̎Zo
	int x2,y2; // ]Rect̉EBȂ݂ɍ́A(x,y)
	x2 = x + r.right - r.left; // x + Width
	y2 = y + r.bottom - r.top; // y + Height

	if (x2<0 || y2<0 || x>=CDirectDraw::m_nScreenXSize || y>=CDirectDraw::m_nScreenYSize) return 0; // ʊO

	if (x<0) { r.left -= x; x=0; }
	if (y<0) { r.top  -= y; y=0; }

	int t;
	t = x2-CDirectDraw::m_nScreenXSize;
	if (t>0)  { r.right -= t; }
	t = y2-CDirectDraw::m_nScreenYSize;
	if (t>0)  { r.bottom -= t; }

	return CDirectDraw::m_lpSecondary->BltFast(x,y,m_lpSurface,&r,DDBLTFAST_WAIT | DDBLTFAST_SRCCOLORKEY);
//	m_bDirty = true;
}

// Blt̓߃L[ȂŁBvÓÂ܂܁i΁j
LRESULT CPlane::BltFast(int x,int y){
// RECTȂꍇÃv[܂邲ƃRs[Ȃ̂B
	RECT r;
	SetRect(&r,0,0,m_nPlaneXSize,m_nPlaneYSize);
	return BltFast(x,y,r); // ̂܂܌ĂяôB
//	m_bDirty = true;
}

// Blt̓߃L[ȂŁBvÓÂ܂܁i΁j
LRESULT CPlane::BltFast(int x,int y,RECT r){
// `̓]BA̓]`͓_(r.right,r.bottom)͊܂܂ȂƂɒӁI
	
	if (CDirectDraw::m_lpSecondary==NULL) return -1; // ȂŁ[HH
	if (m_lpSurface==NULL) return -1; // [I

	// ]Rect̎Zo
	int x2,y2; // ]Rect̉EBȂ݂ɍ́A(x,y)
	x2 = x + r.right - r.left; // x + Width
	y2 = y + r.bottom - r.top; // y + Height

	if (x2<0 || y2<0 || x>=CDirectDraw::m_nScreenXSize || y>=CDirectDraw::m_nScreenYSize) return 0; // ʊO

	if (x<0) { r.left -= x; x=0; }
	if (y<0) { r.top  -= y; y=0; }

	int t;
	t = x2-CDirectDraw::m_nScreenXSize;
	if (t>0)  { r.right -= t; }
	t = y2-CDirectDraw::m_nScreenYSize;
	if (t>0)  { r.bottom -= t; }

	return CDirectDraw::m_lpSecondary->BltFast(x,y,m_lpSurface,&r,DDBLTFAST_WAIT);
//	m_bDirty = true;
}

//////////////////////////////////////////////////////////////////////////////
//	]NbsO@\̏ꍇi{Iɂ́ÃRs[:pj
//////////////////////////////////////////////////////////////////////////////
LRESULT CPlane::ClipBlt(int x,int y,RECT &r2){
// RECTȂꍇÃv[܂邲ƃRs[Ȃ̂B
	RECT r;
	SetRect(&r,0,0,m_nPlaneXSize,m_nPlaneYSize);
	return ClipBlt(x,y,r,r2); // ̂܂܌ĂяôB
//	m_bDirty = true;
}

LRESULT CPlane::ClipBlt(int x,int y,RECT r,RECT &r2){
// `̓]BA̓]`͓_(r.right,r.bottom)͊܂܂ȂƂɒӁI
	
	if (CDirectDraw::m_lpSecondary==NULL) return -1; // ȂŁ[HH
	if (m_lpSurface==NULL) return -1; // [I
	// `Blt̂ClipperȂĂ炭[I
	// 蓮Clipف[ۂǑI(BltFastg邵)

	// Oœ]قDirectDrawClipperۂǑ

	// ]Rect̎Zo
	int x2,y2; // ]Rect̉EBȂ݂ɍ́A(x,y)
	x2 = x + r.right - r.left; // x + Width
	y2 = y + r.bottom - r.top; // y + Height

	if (x2<r2.left || y2<r2.top || x>=r2.right || y>=r2.bottom) return 0; // ʊO

	// this clipping algorithm is thought by yaneurao(M.Isozaki)
	int t;
	t = r2.left-x;
	if (t>0)	{ r.left += t;		x = r2.left;}
	t = r2.top -y;
	if (t>0)	{ r.top	 += t;		y = r2.top;	}
	t = x2-r2.right;
	if (t>0)	{ r.right -= t;					}
	t = y2-r2.bottom;
	if (t>0)	{ r.bottom -= t;				}

	return CDirectDraw::m_lpSecondary->BltFast(x,y,m_lpSurface,&r,DDBLTFAST_WAIT | DDBLTFAST_SRCCOLORKEY);
//	m_bDirty = true;
}

// Blt̓߃L[ȂŁBvÓÂ܂܁i΁j
LRESULT CPlane::ClipBltFast(int x,int y,RECT &r2){
// RECTȂꍇÃv[܂邲ƃRs[Ȃ̂B
	RECT r;
	SetRect(&r,0,0,m_nPlaneXSize,m_nPlaneYSize);
	return ClipBltFast(x,y,r,r2); // ̂܂܌ĂяôB
//	m_bDirty = true;
}

// Blt̓߃L[ȂŁBvÓÂ܂܁i΁j
LRESULT CPlane::ClipBltFast(int x,int y,RECT r,RECT &clip){
// `̓]BA̓]`͓_(r.right,r.bottom)͊܂܂ȂƂɒӁI
	
	if (CDirectDraw::m_lpSecondary==NULL) return -1; // ȂŁ[HH
	if (m_lpSurface==NULL) return -1; // [I

	// ]Rect̎Zo
	int x2,y2; // ]Rect̉EBȂ݂ɍ́A(x,y)
	x2 = x + r.right - r.left; // x + Width
	y2 = y + r.bottom - r.top; // y + Height

	if (x2<clip.left || y2<clip.top || x>=clip.right || y>=clip.bottom) return 0; // ʊO

	int t;
	t = clip.left-x;
	if (t>0)	{ r.left += t;		x = clip.left;}
	t = clip.top -y;
	if (t>0)	{ r.top	 += t;		y = clip.top;	}
	t = x2-clip.right;
	if (t>0)	{ r.right -= t;					}
	t = y2-clip.bottom;
	if (t>0)	{ r.bottom -= t;				}

	return CDirectDraw::m_lpSecondary->BltFast(x,y,m_lpSurface,&r,DDBLTFAST_WAIT);
//	m_bDirty = true;
}

//////////////////////////////////////////////////////////////////////////////
//	BlendBlt
//		炤[邳ɍĂ:p	'99/08/07
LRESULT CPlane::BlendBlt(int x,int y,int ar,int ag,int ab,int br,int bg,int bb) {
	RECT rc;
	SetRect(&rc,0,0,m_nPlaneXSize,m_nPlaneYSize);
	RECT r2;
	SetRect(&r2,0,0,CDirectDraw::m_nScreenXSize,CDirectDraw::m_nScreenYSize);
	return ClipBlendBlt(x,y,rc,ar,ag,ab,br,bg,bb,r2);
}

LRESULT CPlane::BlendBlt(int x,int y,RECT &rc,int ar,int ag,int ab,int br,int bg,int bb) {
	RECT r2;
	SetRect(&r2,0,0,CDirectDraw::m_nScreenXSize,CDirectDraw::m_nScreenYSize);
	return ClipBlendBlt(x,y,rc,ar,ag,ab,br,bg,bb,r2);
}
	
LRESULT CPlane::ClipBlendBlt(int x,int y,int ar,int ag,int ab,int br,int bg,int bb,RECT &r2) {
	RECT rc;
	SetRect(&rc,0,0,m_nPlaneXSize,m_nPlaneYSize);
	return ClipBlendBlt(x,y,rc,ar,ag,ab,br,bg,bb,r2);
}

LRESULT CPlane::ClipBlendBlt(int x,int y,RECT rc,int ar,int ag,int ab,int br,int bg,int bb,RECT &r2) {
	if (CDirectDraw::m_lpSecondary==NULL) return -1;
	if (m_lpSurface	 ==NULL) return -1;

	// ]Rect̎Zo
	int x2,y2; // ]Rect̉EBȂ݂ɍ́A(x,y)
	x2 = x + rc.right - rc.left; // x + Width
	y2 = y + rc.bottom - rc.top; // y + Height
	//-----------------

	if (x2<r2.left || y2<r2.top || x>=r2.right || y>=r2.bottom) return 0; // ʊO

	// this clipping algorithm is thought by yaneurao(M.Isozaki)
	int t;
	t = r2.left-x;
	if (t>0)	{ rc.left += t;		x = r2.left;}
	t = r2.top -y;
	if (t>0)	{ rc.top  += t;		y = r2.top;	}
	t = x2-r2.right;
	if (t>0)	{ rc.right -= t;	x2 = r2.right; }
	t = y2-r2.bottom;
	if (t>0)	{ rc.bottom -= t;	y2 = r2.bottom; }

	//-----------------

	DWORD	colorkey;
	if (m_bUseBlendColorKey) {
		DDCOLORKEY	ddck;
		if (m_lpSurface->GetColorKey(DDCKEY_SRCBLT, &ddck)==DD_OK) {;	// ߃L[𓾂
			colorkey =	ddck.dwColorSpaceLowValue;
		} else {
			colorkey = CLR_INVALID; // Ȃ
		}
	} else {
		colorkey = CLR_INVALID;
	}

	// ZJ_̃bN
	DDSURFACEDESC dddesc;
	ZERO(dddesc); // ꉞ
	dddesc.dwSize = sizeof(dddesc);
	if (CDirectDraw::m_lpSecondary->Lock(NULL,&dddesc,
			DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL)!=DD_OK){
			InnerLog("CPlane::BlendBltSurfaceLockɎs");
			return 2;
	}
	//-------------------

	// Bitmap̃bN`
	DDSURFACEDESC dddesc2;
	ZERO(dddesc2);
	dddesc2.dwSize = sizeof(dddesc2);
	if (m_lpSurface->Lock(NULL,&dddesc2,
		DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL)!=DD_OK){
		InnerLog("CPlane::BlendBltSurfaceLockɎs");
		return 3;
	}
	//-----------------

	// 1X^̑
	LONG lPitch	 = dddesc.lPitch;
	LONG lPitch2 = dddesc2.lPitch;
	// ---------------

	switch (dddesc.ddpfPixelFormat.dwRGBBitCount) {
	case 8:	//	256Ή
//		ClipBltFast(x,y,rc,clip);
		break;

	case 16: { // 65536F[h
		WORD RMask, GMask, BMask;

		RMask = (WORD)dddesc.ddpfPixelFormat.dwRBitMask;
		GMask = (WORD)dddesc.ddpfPixelFormat.dwGBitMask;
		BMask = (WORD)dddesc.ddpfPixelFormat.dwBBitMask;

		WORD *p	 = (WORD*)dddesc.lpSurface;
		WORD *p2 = (WORD*)dddesc2.lpSurface;

		p  = (WORD*)((BYTE*)p +(lPitch *y));	// ZJ_̓]JnyW
		p2 = (WORD*)((BYTE*)p2+(lPitch2*rc.top)) + rc.left - x;	// 

		for(int y3=y;y3<y2;y3++) {
			for (int x3=x;x3<x2;x3++) {
				WORD pixel, px,px2;
				px2= p2[x3];
				if (px2!=colorkey){	// ]J[L[
					px = p [x3];
					pixel  = ((WORD)((((px2&RMask)*ar)+((px&RMask)*br))>>8)&RMask);
					pixel |= ((WORD)((((px2&GMask)*ag)+((px&GMask)*bg))>>8)&GMask);
					pixel |= ((WORD)((((px2&BMask)*ab)+((px&BMask)*bb))>>8)&BMask);
					p[x3] = pixel;
				}
			}
			p  = (WORD*)((BYTE*)p +lPitch ); // PX^̑
			p2 = (WORD*)((BYTE*)p2+lPitch2);
			// BYTEɃLXgĂȂƌvZԈႤ:p
		}
	} break;

	case 24: {
		BYTE *p	 = (BYTE*)dddesc.lpSurface;
		BYTE *p2 = (BYTE*)dddesc2.lpSurface;

		p  = (BYTE*)p +(lPitch*y);	// ZJ_̓]JnyW
		p2 = (BYTE*)p2+(lPitch2*rc.top) + (rc.left - x)*3; // 

		int ox=x*3,ox2=x2*3;

		BYTE r,g,b;
		r = colorkey & 0xff;
		g = (colorkey >> 8) & 0xff;
		b = (colorkey >> 16) & 0xff;
		for(int y3=y;y3<y2;y3++) {
			for (int x3=ox;x3<ox2;) {
				if (p2[x3]!=r || p2[x3+1]!=g || p2[x3+2]!=b ||
					(colorkey==CLR_INVALID)) {
					p[x3] = ((p2[x3]*ar)+(p[x3]*br))>>8; x3++;
					p[x3] = ((p2[x3]*ag)+(p[x3]*bg))>>8; x3++;
					p[x3] = ((p2[x3]*ab)+(p[x3]*bb))>>8; x3++;
				} else {
					x3+=3;
				}
			}
			p  = (BYTE*)(p +lPitch ); // PX^̑
			p2 = (BYTE*)(p2+lPitch2);
			// BYTEɃLXgĂȂƌvZԈႤ:p
		}
	} break;

	case 32: {
		DWORD RMask, GMask, BMask;

		RMask = dddesc.ddpfPixelFormat.dwRBitMask;
		GMask = dddesc.ddpfPixelFormat.dwGBitMask;
		BMask = dddesc.ddpfPixelFormat.dwBBitMask;

		DWORD *p  = (DWORD*)dddesc.lpSurface;
		DWORD *p2 = (DWORD*)dddesc2.lpSurface;

		p  = (DWORD*)((BYTE*)p +(lPitch *y));	// ZJ_̓]JnyW
		p2 = (DWORD*)((BYTE*)p2+(lPitch2*rc.top)) + rc.left - x; // 

		for(int y3=y;y3<y2;y3++) {
			for (int x3=x;x3<x2;x3++) {
				DWORD pixel, px,px2;
				px2 = p2[x3];
				if (px2!=colorkey){	// ]J[L[
					px	= p [x3];
					// ӂN[HVȂȂ...
					// DWORDLONGô͂ƑlȂ悤ȋC邯:p
					pixel  = (DWORD)((((DWORDLONG)(px2&RMask)*ar)+((DWORDLONG)(px&RMask)*br))>>8)&RMask;
					pixel |= (DWORD)((((DWORDLONG)(px2&GMask)*ag)+((DWORDLONG)(px&GMask)*bg))>>8)&GMask;
					pixel |= (DWORD)((((DWORDLONG)(px2&BMask)*ab)+((DWORDLONG)(px&BMask)*bb))>>8)&BMask;
					p[x3]  = pixel;
				}
			}
			p  = (DWORD*)((BYTE*)p + lPitch); // PX^̑
			p2 = (DWORD*)((BYTE*)p2+lPitch2);
		}

	} break; // end case
	} // end switch
	CDirectDraw::m_lpSecondary->Unlock(NULL);
	m_lpSurface->Unlock(NULL);

	return 0;
}

//////////////////////////////////////////////////////////////////////////////
//	{w@\tblt̎	'99/08/25

LRESULT	CPlane::Blt(int x,int y,double rx,double ry){
	RECT sr;
	SetRect(&sr,0,0,m_nPlaneXSize,m_nPlaneYSize);		//	]̓v[ۂ
	RECT clip;
	SetRect(&clip,0,0,CDirectDraw::m_nScreenXSize,CDirectDraw::m_nScreenYSize);	//	Nbv͈͉͂ʃTCY
	return ClipBltS(x,y,sr,clip,rx,ry,true);
}

LRESULT	CPlane::Blt(int x,int y,RECT &sr,double rx,double ry){
	RECT clip;
	SetRect(&clip,0,0,CDirectDraw::m_nScreenXSize,CDirectDraw::m_nScreenYSize);	//	Nbv͈͉͂ʃTCY
	return ClipBltS(x,y,sr,clip,rx,ry,true);
}

LRESULT	CPlane::BltFast(int x,int y,double rx,double ry){
	RECT sr;
	SetRect(&sr,0,0,m_nPlaneXSize,m_nPlaneYSize);		//	]̓v[ۂ
	RECT clip;
	SetRect(&clip,0,0,CDirectDraw::m_nScreenXSize,CDirectDraw::m_nScreenYSize);	//	Nbv͈͉͂ʃTCY
	return ClipBltS(x,y,sr,clip,rx,ry,false);
}

LRESULT	CPlane::BltFast(int x,int y,RECT &sr,double rx,double ry){
	RECT clip;
	SetRect(&clip,0,0,CDirectDraw::m_nScreenXSize,CDirectDraw::m_nScreenYSize);	//	Nbv͈͉͂ʃTCY
	return ClipBltS(x,y,sr,clip,rx,ry,false);
}

LRESULT	CPlane::ClipBlt(int x,int y,RECT &clip,double rx,double ry){
	RECT sr;
	SetRect(&sr,0,0,m_nPlaneXSize,m_nPlaneYSize);		//	]̓v[ۂ
	return ClipBltS(x,y,sr,clip,rx,ry,true);
}

LRESULT	CPlane::ClipBlt(int x,int y,RECT &sr,RECT &clip,double rx,double ry){
	return ClipBltS(x,y,sr,clip,rx,ry,true);
}

LRESULT	CPlane::ClipBltFast(int x,int y,RECT &clip,double rx,double ry){
	RECT sr;
	SetRect(&sr,0,0,m_nPlaneXSize,m_nPlaneYSize);		//	]̓v[ۂ
	return ClipBltS(x,y,sr,clip,rx,ry,false);
}

LRESULT	CPlane::ClipBltFast(int x,int y,RECT &sr,RECT &clip,double rx,double ry){
	return ClipBltS(x,y,sr,clip,rx,ry,false);
}

/////		Ⴒ悤ǁAǁAȉClipBltSĂԂȂ	/////
DDBLTFX	CPlane::m_ddbltfx;		// staticȂ́I

LRESULT CPlane::ClipBltS(int x,int y,RECT sr,RECT &clip,double rx,double ry,bool bUseColorKey){
	if (CDirectDraw::m_lpSecondary==NULL) return -1; // ȂŁ[HH
	if (m_lpSurface==NULL) return -1; // [I

	if (rx==0||ry==0) return 0;	//	܁[AȂ[Ƃ́A:p
	if (ry<0) ry=rx;

	RECT dist;
	SetRect(&dist,x,y,x+(int)((sr.right-sr.left)*rx),y+(int)((sr.bottom-sr.top)*ry));	//	]Rect

	if (dist.right<clip.left || dist.bottom<clip.top || dist.left>=clip.right || dist.top>=clip.bottom) return 0; // ʊO

	// this clipping algorithm is thought by yaneurao(M.Isozaki) '99/08/25
	int t;
	t = clip.left-dist.left;
	if (t>0)	{ sr.left  += (int)(t/rx);		dist.left = clip.left;		}
	t = clip.top-dist.top;
	if (t>0)	{ sr.top   += (int)(t/ry);		dist.top  = clip.top;		}
	t = dist.right-clip.right;
	if (t>0)	{ sr.right	-=(int)(t/rx);		dist.right = clip.right;	}
	t = dist.bottom-clip.bottom;
	if (t>0)	{ sr.bottom -=(int)(t/ry);		dist.bottom= clip.bottom;	}

	//	J[L[gǂœ]ύX
	if (bUseColorKey) {
		return CDirectDraw::m_lpSecondary->Blt(&dist,m_lpSurface,&sr,DDBLT_WAIT | DDBLT_KEYSRC,&m_ddbltfx);
	} else {
		return CDirectDraw::m_lpSecondary->Blt(&dist,m_lpSurface,&sr,DDBLT_WAIT,&m_ddbltfx);
	}
}

//////////////////////////////////////////////////////////////////////////////
//	gk@\tBlendBlt	'99/08/26
LRESULT CPlane::BlendBlt(int x,int y,int ar,int ag,int ab,int br,int bg,int bb,double rx,double ry) {
	RECT rc;
	SetRect(&rc,0,0,m_nPlaneXSize,m_nPlaneYSize);
	RECT clip;
	SetRect(&clip,0,0,CDirectDraw::m_nScreenXSize,CDirectDraw::m_nScreenYSize);
	return ClipBlendBlt(x,y,rc,ar,ag,ab,br,bg,bb,clip,rx,ry);
}

LRESULT CPlane::BlendBlt(int x,int y,RECT &rc,int ar,int ag,int ab,int br,int bg,int bb,double rx,double ry) {
	RECT clip;
	SetRect(&clip,0,0,CDirectDraw::m_nScreenXSize,CDirectDraw::m_nScreenYSize);
	return ClipBlendBlt(x,y,rc,ar,ag,ab,br,bg,bb,clip,rx,ry);
}
	
LRESULT CPlane::ClipBlendBlt(int x,int y,int ar,int ag,int ab,int br,int bg,int bb,RECT &clip,double rx,double ry) {
	RECT rc;
	SetRect(&rc,0,0,m_nPlaneXSize,m_nPlaneYSize);
	return ClipBlendBlt(x,y,rc,ar,ag,ab,br,bg,bb,clip,rx,ry);
}

LRESULT CPlane::ClipBlendBlt(int x,int y,RECT sr,int ar,int ag,int ab,int br,int bg,int bb,RECT &clip,double rx,double ry) {
	if (CDirectDraw::m_lpSecondary==NULL) return -1;
	if (m_lpSurface	 ==NULL) return -1;

	if (rx==0 || ry==0) return 0;	//	...
	if (ry<0) ry=rx;

	// ]Rect̎Zo
	RECT dist;
	SetRect(&dist,x,y,x+(int)((sr.right-sr.left)*rx),y+(int)((sr.bottom-sr.top)*ry));	//	]Rect

	if (dist.right<clip.left || dist.bottom<clip.top || dist.left>=clip.right || dist.top>=clip.bottom) return 0; // ʊO

	// this clipping algorithm is thought by yaneurao(M.Isozaki) '99/08/26
	int t;
	t = clip.left-dist.left;
	if (t>0)	{ sr.left  += (int)(t/rx);		dist.left = clip.left;		}
	t = clip.top-dist.top;
	if (t>0)	{ sr.top   += (int)(t/ry);		dist.top  = clip.top;		}
	t = dist.right-clip.right;
	if (t>0)	{ sr.right	-=(int)(t/rx);		dist.right = clip.right;	}
	t = dist.bottom-clip.bottom;
	if (t>0)	{ sr.bottom -=(int)(t/ry);		dist.bottom= clip.bottom;	}

	if (dist.right<clip.left || dist.bottom<clip.top || dist.left>=clip.right || dist.top>=clip.bottom) return 0; // ʊO

	//-----------------
	DWORD	colorkey;
	if (m_bUseBlendColorKey) {
		DDCOLORKEY	ddck;
		if (m_lpSurface->GetColorKey(DDCKEY_SRCBLT, &ddck)==DD_OK) {;	// ߃L[𓾂
			colorkey =	ddck.dwColorSpaceLowValue;
		} else {
			colorkey = CLR_INVALID; // Ȃ
		}
	} else {
		colorkey = CLR_INVALID;
	}

	// ZJ_̃bN
	DDSURFACEDESC dddesc;
	ZERO(dddesc); // ꉞ
	dddesc.dwSize = sizeof(dddesc);
	if (CDirectDraw::m_lpSecondary->Lock(NULL,&dddesc,
			DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL)!=DD_OK){
			InnerLog("CPlane::BlendBltSurfaceLockɎs");
			return 2;
	}
	//-------------------
	// Bitmap̃bN`
	DDSURFACEDESC dddesc2;
	ZERO(dddesc2);
	dddesc2.dwSize = sizeof(dddesc2);
	if (m_lpSurface->Lock(NULL,&dddesc2,
		DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL)!=DD_OK){
		InnerLog("CPlane::BlendBltSurfaceLockɎs");
		return 3;
	}
	//-----------------

	// 1X^̑
	LONG lPitch	 = dddesc.lPitch;
	LONG lPitch2 = dddesc2.lPitch;
	// ---------------

	switch (dddesc.ddpfPixelFormat.dwRGBBitCount) {
	case 8:	// 256Ή
//		ClipBltFast(x,y,rc,clip);
		break;

	case 16: { // 65536F[h
		WORD RMask, GMask, BMask;

		RMask = (WORD)dddesc.ddpfPixelFormat.dwRBitMask;
		GMask = (WORD)dddesc.ddpfPixelFormat.dwGBitMask;
		BMask = (WORD)dddesc.ddpfPixelFormat.dwBBitMask;

		WORD *p	 = (WORD*)dddesc.lpSurface;
		WORD *p2 = (WORD*)dddesc2.lpSurface;

		p  = (WORD*)((BYTE*)p +(lPitch *y));	// ZJ_̓]JnyW
		p2 = (WORD*)((BYTE*)p2+(lPitch2*sr.top)) + sr.left - (BYTE)((double)dist.left/rx);	// 
		WORD *p3 = p2;

		for(int y3=dist.top;y3<dist.bottom;y3++) {
			for (int x3=dist.left;x3<dist.right;x3++) {
				WORD pixel, px,px2;
				px2= p2[(int)((double)x3/rx)];	//	ȊZȂǑxxO:p
				if (px2!=colorkey){	// ]J[L[
					px = p[x3];
					pixel  = ((WORD)((((px2&RMask)*ar)+((px&RMask)*br))>>8)&RMask);
					pixel |= ((WORD)((((px2&GMask)*ag)+((px&GMask)*bg))>>8)&GMask);
					pixel |= ((WORD)((((px2&BMask)*ab)+((px&BMask)*bb))>>8)&BMask);
					p[x3] = pixel;
				}
			}
			p  = (WORD*)((BYTE*)p +lPitch ); // PX^̑
			p2 = (WORD*)((BYTE*)p3+lPitch2*(int)((double)(y3-dist.top)/ry));
			// BYTEɃLXgĂȂƌvZԈႤ:p
		}
	} break;

	case 24: {
		BYTE *p	 = (BYTE*)dddesc.lpSurface;
		BYTE *p2 = (BYTE*)dddesc2.lpSurface;

		p  = (BYTE*)p +(lPitch*y);	// ZJ_̓]JnyW
		p2 = (BYTE*)p2+(lPitch2*sr.top) + (sr.left - (BYTE)((double)dist.left/rx))*3; // 
		BYTE *p3 = p2;

		int ox=dist.left*3,ox2=dist.right*3;

		BYTE r,g,b;
		r = colorkey & 0xff;
		g = (colorkey >> 8) & 0xff;
		b = (colorkey >> 16) & 0xff;
		for(int y3=dist.top;y3<dist.bottom;y3++) {
			for (int x3=ox;x3<ox2;x3+=3) {
				if (p2[x3]!=r || p2[x3+1]!=g || p2[x3+2]!=b ||
					(colorkey==CLR_INVALID)){
					int pos;
					pos = (int)((double)(x3/3)/rx)*3;
					p[x3+0] = ((p2[pos+0]*ar)+(p[x3+0]*br))>>8;
					p[x3+1] = ((p2[pos+1]*ag)+(p[x3+1]*bg))>>8;
					p[x3+2] = ((p2[pos+2]*ab)+(p[x3+2]*bb))>>8;
				}
			}
			p  = (BYTE*)(p +lPitch ); // PX^̑
			p2 = (BYTE*)((BYTE*)p3+lPitch2*(int)((double)(y3-dist.top)/ry));
			// BYTEɃLXgĂȂƌvZԈႤ:p
		}
	} break;

	case 32: {
		DWORD RMask, GMask, BMask;

		RMask = dddesc.ddpfPixelFormat.dwRBitMask;
		GMask = dddesc.ddpfPixelFormat.dwGBitMask;
		BMask = dddesc.ddpfPixelFormat.dwBBitMask;

		DWORD *p  = (DWORD*)dddesc.lpSurface;
		DWORD *p2 = (DWORD*)dddesc2.lpSurface;

		p  = (DWORD*)((BYTE*)p +(lPitch *y));	// ZJ_̓]JnyW
		p2 = (DWORD*)((BYTE*)p2+(lPitch2*sr.top)) + sr.left - (BYTE)((double)dist.left/rx); // 

		DWORD *p3 = p2;

		for(int y3=dist.top;y3<dist.bottom;y3++) {
			for (int x3=dist.left;x3<dist.right;x3++) {
				DWORD pixel, px,px2;
				px2 = p2[(int)((double)x3/rx)];
				if (px2!=colorkey){
					px	= p [x3];
					// ӂN[HVȂȂ...
					// DWORDLONGô͂ƑlȂ悤ȋC邯:p
					pixel  = (DWORD)((((DWORDLONG)(px2&RMask)*ar)+((DWORDLONG)(px&RMask)*br))>>8)&RMask;
					pixel |= (DWORD)((((DWORDLONG)(px2&GMask)*ag)+((DWORDLONG)(px&GMask)*bg))>>8)&GMask;
					pixel |= (DWORD)((((DWORDLONG)(px2&BMask)*ab)+((DWORDLONG)(px&BMask)*bb))>>8)&BMask;
					p[x3]  = pixel;
				}
			}
			p  = (DWORD*)((BYTE*)p + lPitch); // PX^̑
			p2 = (DWORD*)((BYTE*)p3+lPitch2*(int)((double)(y3-dist.top)/ry));
			// BYTEɃLXgĂȂƌvZԈႤ:p
		}

	} break; // end case
	} // end switch
	CDirectDraw::m_lpSecondary->Unlock(NULL);
	m_lpSurface->Unlock(NULL);

	return 0;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CPlane::FlushBlt(RECT &r){
	//	v[ɑ΂ălK|W]@\		added '99/12/1

	if (m_lpSurface	 ==NULL) return -1;
	//	蔲ŃNbvĂȂ̂Łc

	//	lock the surface...
	DDSURFACEDESC dddesc;
	ZERO(dddesc);
	dddesc.dwSize = sizeof(dddesc);
	if (m_lpSurface->Lock(NULL,&dddesc,
		DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL)!=DD_OK){
		InnerLog("CPlane::FlushBltSurfaceLockɎs");
		return 1;
	}

	// 1X^̑
	LONG lPitch	 = dddesc.lPitch;

	switch (dddesc.ddpfPixelFormat.dwRGBBitCount) {
	case 8:	{	// 256F[h
		for(int y=r.top;y<r.bottom;y++){
			BYTE *p;
			p = (BYTE*)dddesc.lpSurface + y*lPitch + r.left;
			for(int x=r.left;x<r.right;x++){
				*(p++) ^= 0xff;	//	xor邾:p
			}
		}
		break;
			}
	case 16: {	// 65536F[h
		for(int y=r.top;y<r.bottom;y++){
			WORD *p;
			p = (WORD*)((BYTE*)dddesc.lpSurface + y*lPitch) + r.left;
			for(int x=r.left;x<r.right;x++){
				*(p++) ^= 0xffff;	//	xor邾:p
			}
		}
		break;
			 }
	case 24: {	//	full color
		for(int y=r.top;y<r.bottom;y++){
			BYTE *p;
			p = (BYTE*)dddesc.lpSurface + y*lPitch + r.left*3;
			for(int x=r.left;x<r.right;x++){	//	3񂩂Ƃ`:p
				*(p++) ^= 0xff;	//	xor邾:p
				*(p++) ^= 0xff;
				*(p++) ^= 0xff;
			}
		}
		break;
			 }
	case 32: {	//	true color
		for(int y=r.top;y<r.bottom;y++){
			DWORD *p;
			p = (DWORD*)((BYTE*)dddesc.lpSurface + y*lPitch) + r.left;
			for(int x=r.left;x<r.right;x++){
				*(p++) ^= 0xffffffff;	//	xor邾:p
			}
		}
		break;
			}
	} // end switch
	m_lpSurface->Unlock(NULL);
	return 0;
}

LRESULT	CPlane::MosaicBlt(RECT &r,int d){
	//@v[ɑ΂ăUCN@\		added '99/12/1
	//	d :	ʎqx

	if (m_lpSurface	 ==NULL) return -1;
	//	蔲ŃNbvĂȂ̂Łc

	//	lock the surface...
	DDSURFACEDESC dddesc;
	ZERO(dddesc);
	dddesc.dwSize = sizeof(dddesc);
	if (m_lpSurface->Lock(NULL,&dddesc,
		DDLOCK_WAIT|DDLOCK_SURFACEMEMORYPTR,NULL)!=DD_OK){
		InnerLog("CPlane::MosaicBltSurfaceLockɎs");
		return 1;
	}

	// 1X^̑
	LONG lPitch	 = dddesc.lPitch;

	switch (dddesc.ddpfPixelFormat.dwRGBBitCount) {
	case 8:	{	// 256F[h
		for(int y=r.top;y<r.bottom;y+=d){
			int d2;		//	[̒[
			if (y+d>r.bottom) d2=r.bottom-y; else d2=d;
			for(int x=r.left;x<r.right;x+=d){
				int d1;	//	E[̒[
				if (x+d>r.right) d1=r.right-x; else d1=d;

				BYTE *p,*p2;
				p = (BYTE*)dddesc.lpSurface + y*lPitch + x;
				BYTE c;	// \_̐F
				c = *p;
				for(int py=0;py<d2;py++){
					p2 = p;
					for(int px=0;px<d1;px++){
						*(p++) = c;
					}
					p = p2 + lPitch;	//	next line
				}
			}
		}
		break;
			}
	case 16: {	// 65536F[h
		for(int y=r.top;y<r.bottom;y+=d){
			int d2;		//	[̒[
			if (y+d>r.bottom) d2=r.bottom-y; else d2=d;
			for(int x=r.left;x<r.right;x+=d){
				int d1;	//	E[̒[
				if (x+d>r.right) d1=r.right-x; else d1=d;

				WORD *p,*p2;
				p = (WORD*)((BYTE*)dddesc.lpSurface + y*lPitch) + x;
				WORD c;	// \_̐F
				c = *p;
				for(int py=0;py<d2;py++){
					p2 = p;
					for(int px=0;px<d1;px++){
						*(p++) = c;
					}
					p = (WORD*)((BYTE*)p2 + lPitch);	//	next line
				}
			}
		}
		break;
			 }
	case 24: {	//	full color
		for(int y=r.top;y<r.bottom;y+=d){
			int d2;		//	[̒[
			if (y+d>r.bottom) d2=r.bottom-y; else d2=d;
			for(int x=r.left;x<r.right;x+=d){
				int d1;	//	E[̒[
				if (x+d>r.right) d1=r.right-x; else d1=d;

				BYTE *p,*p2;
				p = (BYTE*)dddesc.lpSurface + y*lPitch + x*3;
				BYTE c1,c2,c3;	// \_̐F
				c1 = *p; c2 = *(p+1); c3 = *(p+2);
				for(int py=0;py<d2;py++){
					p2 = p;
					for(int px=0;px<d1;px++){	//	R񂩂Ƃ`
						*(p++) = c1;
						*(p++) = c2;
						*(p++) = c3;
					}
					p = p2 + lPitch;	//	next line
				}
			}
		}
		break;
			 }
	case 32: {	//	true color
		for(int y=r.top;y<r.bottom;y+=d){
			int d2;		//	[̒[
			if (y+d>r.bottom) d2=r.bottom-y; else d2=d;
			for(int x=r.left;x<r.right;x+=d){
				int d1;	//	E[̒[
				if (x+d>r.right) d1=r.right-x; else d1=d;

				DWORD *p,*p2;
				p = (DWORD*)((BYTE*)dddesc.lpSurface + y*lPitch) + x;
				DWORD c;	// \_̐F
				c = *p;
				for(int py=0;py<d2;py++){
					p2 = p;
					for(int px=0;px<d1;px++){
						*(p++) = c;
					}
					p = (DWORD*)((BYTE*)p2 + lPitch);	//	next line
				}
			}
		}
		break;
			}
	} // end switch
	m_lpSurface->Unlock(NULL);
	return 0;

	return 0;
}

//////////////////////////////////////////////////////////////////////////////

// fBXvC̐F𒲂ׂ̂GetDisplayMode͎gĂ͂Ȃ
int CPlane::GetBpp(void){
	HDC		hdc;
	hdc = GetDC(NULL);

	int bpp;
	bpp = GetDeviceCaps(hdc, PLANES) * GetDeviceCaps(hdc, BITSPIXEL);
	ReleaseDC(NULL, hdc);

	return bpp;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CPlane::ReleaseBitmapAll(void){ // Sv[̉	
	for (set<CPlane*>::iterator it=m_lpaPlane.begin();it!=m_lpaPlane.end();it++){
		(*it)->ReleaseBitmap();
	}
	return 0;
}
	
LRESULT CPlane::ReleaseBufferAll(void){ // Sv[̃[X
	if (m_lpaPlane.size()==0) return 0;

	for (set<CPlane*>::iterator it=m_lpaPlane.begin();it!=m_lpaPlane.end();it++){
		(*it)->ReleaseBuffer();
	}
	return 0;
}

LRESULT CPlane::RestoreAll(void){ // Sv[̃[h
	for (set<CPlane*>::iterator it=m_lpaPlane.begin();it!=m_lpaPlane.end();it++){
		(*it)->Restore();
	}

/*
	RestoreAll2();
	//	{́ApbgACYɍsȂׂA
	//	Ƃ肠\ȂĂ͂ȂȂ̂
*/

	return 0;
}

LRESULT CPlane::RestoreAll2(void){
	// pbg̃ACỸXgA
	for (set<CPlane*>::iterator it=m_lpaPlane.begin();it!=m_lpaPlane.end();it++){
		// I[i[h[^Cv́AŃXgAI
		if ((*it)->m_bOwnerDraw) (*it)->Restore();
	}
	return 0;
}

//////////////////////////////////////////////////////////////////////////////

LRESULT CPlane::CreateSurface(int x,int y){
	if (CDirectDraw::m_lpDirectDraw==NULL) {
		InnerLog("CPlane::CreatePlaneCDirectDraw::m_lpDirectDraw==NULL");
		return 1; // ߂
	}
	m_DirectDrawBitmapFile = "";	// ȊǗ
	m_DirectDrawBitmapFile2 = "";	// ȊǗ
	
	RELEASE_SAFE(m_lpSurface);

	DDSURFACEDESC ddsd;
	ZERO(ddsd);
	ddsd.dwSize = sizeof(ddsd);
	ddsd.dwFlags = DDSD_CAPS | DDSD_HEIGHT | DDSD_WIDTH;
	ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;

	// TCYۑĂ
	m_nPlaneXSize = ddsd.dwWidth  = x;
	m_nPlaneYSize = ddsd.dwHeight = y;

	
	if (CDirectDraw::m_lpDirectDraw->CreateSurface(&ddsd,&m_lpSurface,NULL)!=DD_OK){
		InnerLog("CPlane::CreateSurfaceCreateSurfaceɎs");
		return 2; // [
	}

	// wiŏƂ...
	DDBLTFX fx;
	ZERO(fx);
	fx.dwSize = sizeof(fx);
	fx.dwFillColor = 0; // m_dwFillColor;
	m_lpSurface->Blt(NULL,NULL,NULL,DDBLT_COLORFILL|DDBLT_WAIT,&fx);

	// ߐFw肵ƂƂ...
	SetColorKey(RGB(0,0,0));

	return 0;
}

LRESULT CPlane::BeginPaint(HDC &hdc){
	if (m_hdc!=NULL) {
		InnerLog("CPlane::EndPaintĂяoĂȂ̂BeginPaintĂяoꂽ");
		return 1;
	}
	if (m_lpSurface==NULL) return 2;
	if (m_lpSurface->GetDC(&hdc)!=DD_OK) return 3;
	m_hdc = hdc;
	return 0;
}

LRESULT CPlane::EndPaint(void){
	if (m_hdc==NULL) {
		InnerLog("CPlane::BeginPaintĂяoĂȂ̂EndPaintĂяoꂽ");
		return 1;
	}
	if (m_lpSurface==NULL) return 2;
	if (m_lpSurface->ReleaseDC(m_hdc)!=DD_OK) return 3;
	m_hdc = NULL;
	return 0;
}

LRESULT CPlane::EnableBlendColorKey(bool b){
	// uhnBlt̓]J[L[
	m_bUseBlendColorKey = b;
	return 0;
}

LRESULT	CPlane::SwapToSecondary(void){
	//	ZJ_Ɠꊷ@\BʔzłH

	int		t1,t2;
	t1 = m_nPlaneXSize;
	t2 = m_nPlaneYSize;
	m_nPlaneXSize = CDirectDraw::m_nScreenXSize;
	m_nPlaneYSize = CDirectDraw::m_nScreenYSize;
	CDirectDraw::m_nScreenXSize = t1;
	CDirectDraw::m_nScreenYSize = t2;

	LPDIRECTDRAWSURFACE t3;
	t3 = m_lpSurface;
	m_lpSurface = CDirectDraw::m_lpSecondary;
	CDirectDraw::m_lpSecondary = t3;

	return 0;
}
