//
//		BltTrans for yaneGameScript2000 ver.1.03
//			programmed by yaneurao (M.Isozaki) '00/01/10
//

// #include "../scriptsdk/scriptsdk.h"	//	ꂳincludeĂ܂΂Ƃplaneg:p

#include "yanePlane.h"
#include "yaneGameTime.h"
#include <math.h>		//	for wave effect
#include <stdlib.h>		//	for rand
//////////////////////////////////////////////////////////////////////////////

//	ʂBlt}N
#define BLT() {\
	if (bltmode) {						\
		Blt(x,y);						\
	} else {							\
		BltFast(x,y);					\
	}									\
					}


//	C]}N
#define BLTHLINE(p) {\
	RECT rc;							\
	SetRect(&rc,0,p,sx,p+1);			\
	if (bltmode) {						\
		Blt(x,y+p,rc);					\
	} else {							\
		BltFast(x,y+p,rc);				\
	}									\
					}

//	C]}N
#define BLTVLINE(p) {\
	RECT rc;							\
	SetRect(&rc,p,0,p+1,sy);			\
	if (bltmode) {						\
		Blt(x+p,y,rc);					\
	} else {							\
		BltFast(x+p,y,rc);				\
	}									\
					}

//	Cpnhbgڂkhbg]}N
#define BLTHLINE2(p,n,k) {\
	RECT rc;									\
	int k2,n2;									\
	k2 = k;										\
	n2 = n;										\
	if (n2+k2>sx) { k2=sx-n2; }					\
	if (n2<0) { k2+=n2; n2=0; if (k2<0) k2=0;}	\
	SetRect(&rc,n2,p,n2+k2,p+1);				\
	if (bltmode) {								\
		Blt(x+n2,y+p,rc);						\
	} else {									\
		BltFast(x+n2,y+p,rc);					\
	}											\
					}

//	`]}N(Clip)
#define BLTRECT(_x,_y,_sx,_sy) {\
	RECT rc;									\
	int	sx2,sy2;								\
	sx2=_sx; sy2=_sy;							\
	int x2,y2;									\
	x2 = _x; y2=_y;								\
	if(x2<0) { x2=0; }							\
	if(y2<0) { y2=0; }							\
	if(x2+sx2 > sx) { sx2 = sx-x2; }			\
	if(y2+sy2 > sy) { sy2 = sy-y2; }			\
	SetRect(&rc,x2,y2,x2+sx2,y2+sy2);			\
	if (bltmode) {								\
		Blt(x+x2,y+y2,rc);						\
	} else {									\
		BltFast(x+x2,y+y2,rc);					\
	}											\
					}

//	`ItZbgē]}N(Clip)
#define BLTRECTOFFSET(_x,_y,_sx,_sy,_ox,_oy) {\
	RECT rc;									\
	int	sx2,sy2;								\
	sx2=_sx; sy2=_sy;							\
	int x2,y2;									\
	x2 = _x; y2=_y;								\
	if(x2<0) { x2=0; }							\
	if(y2<0) { y2=0; }							\
	if(x2+sx2 > sx) { sx2 = sx-x2; }			\
	if(y2+sy2 > sy) { sy2 = sy-y2; }			\
	SetRect(&rc,x2,y2,x2+sx2,y2+sy2);			\
	if (bltmode) {								\
		Blt(x+x2+(_ox),y+y2+(_oy),rc);			\
	} else {									\
		BltFast(x+x2+(_ox),y+y2+(_oy),rc);		\
	}											\
					}

//	ߏ̋`]}N
#define BLTRECTNEIGHBOR(_x,_y,_sx,_sy,level) {\
	RECT rc;									\
	int	sx2,sy2;								\
	sx2=_sx; sy2=_sy;							\
	if(_x+sx2 > sx) { sx2 = sx-_x; }			\
	if(_y+sy2 > sy) { sy2 = sy-_y; }			\
	int ox,oy;									\
	ox = rand() % level; oy = rand() % level;	\
	if (ox+_x+sx2 > sx) ox=0;					\
	if (oy+_y+sy2 > sy) oy=0;					\
	SetRect(&rc,_x+ox,_y+oy,_x+sx2+ox,_y+sy2+oy);\
	if (bltmode) {								\
		Blt(x+_x,y+_y,rc);						\
	} else {									\
		BltFast(x+_x,y+_y,rc);					\
	}											\
					}

//	_]}Nixj
#define BLTPSET(_x,_y) {\
	RECT rc;									\
	SetRect(&rc,_x,_y,_x+1,_y+1);				\
	if (bltmode) {								\
		Blt(x+_x,y+_y,rc);						\
	} else {									\
		BltFast(x+_x,y+_y,rc);					\
	}											\
					}

//	C炵ē]}N
#define BLTHLINEOFFSET(p,ox) {\
	RECT rc;							\
	SetRect(&rc,0,p,sx,p+1);			\
	if (bltmode) {						\
		Blt(x+ox,y+p,rc);				\
	} else {							\
		BltFast(x+ox,y+p,rc);			\
	}									\
					}

//	CrxXgb`ē]}N
#define BLTHLINEST(p,rx) {\
	RECT rc;													\
	SetRect(&rc,0,p,sx,p+1);									\
	if (bltmode) {												\
		Blt(x-(int)((sx>>1)*(rx-1)),y+p,rc,rx);					\
	} else {													\
		BltFast(x-(int)((sx>>1)*(rx-1)),y+p,rc,rx);				\
	}															\
					}

//	CcryXgb`ē]}N
#define BLTVLINEST(p,ry) {\
	RECT rc;													\
	SetRect(&rc,p,0,p+1,sy);									\
	if (bltmode) {												\
		Blt(x+p,y-(int)((sy>>1)*(ry-1)),rc,1,ry);				\
	} else {													\
		BltFast(x+p,y-(int)((sy>>1)*(ry-1)),rc,1,ry);			\
	}															\
					}

//	C㉺ɂ炵ē]}N
#define BLTHLINEFROM(p,oy) {\
	RECT rc;							\
	SetRect(&rc,0,p,sx,p+1);			\
	if (bltmode) {						\
		Blt(x,y+oy,rc);					\
	} else {							\
		BltFast(x,y+oy,rc);				\
	}									\
					}

//	CEɂ炵ē]}N
#define BLTVLINEFROM(p,ox) {\
	RECT rc;							\
	SetRect(&rc,p,0,p+1,sy);			\
	if (bltmode) {						\
		Blt(x+ox,y,rc);					\
	} else {							\
		BltFast(x+ox,y,rc);				\
	}									\
					}

//////////////////////////////////////////////////////////////////////////////
class BltTransTable {
public:
	BltTransTable(void) {
		srand((unsigned)CTimeBase::timeGetTime());	//	ŏ\ł傤
		int i;
		srand(NULL);	//	randomizeiŒ^j
		for(i=0;i<256;i++){
			RandTable[i] = rand() & 255;
		}
		const double PI = 3.141592653589793238462643;
		for(i=0;i<360;i++){
			SinTable[i] = sin((double)i*PI/180);
		}
	}
	BYTE RandTable[256];	//	UCNp_p^[
	double SinTable[360];
};

//////////////////////////////////////////////////////////////////////////////

//	Blt Transitionally
LRESULT CPlane::BltTrans(int x,int y,int nEffectType,int nPhase){
	static BltTransTable blt_table;
	//	local static objectȂ̂ŏ͏߂ČĂяoƂɂ̂ݍsȂ

	int	bltmode = nEffectType &1;	// BltModeeffect̉1rbgŌ܂
	nEffectType >>= 1;

	if (nPhase == 256) {
		if (bltmode) {
			return Blt(x,y);
		} else {
			return BltFast(x,y);
		}
	}
	if (nPhase == 0) return 0;

	int sx,sy;
	GetSize(sx,sy);

	switch (nEffectType) {
	case 0:{	// cBlt8hbg
		for(int px=0;px<sx;px++){
			if ((px & 7) <= (nPhase >> 5)) {
				BLTVLINE(px);
			}
		}
		break;
		   }
	case 1:{	// cBltE8hbg
		for(int px=0;px<sx;px++){
			if ((7-(px & 7)) <= (nPhase >> 5)) {
				BLTVLINE(px);
			}
		}
		break;
		   }
	case 2:{	// cBlt16hbg
		for(int px=0;px<sx;px++){
			if ((px & 15) <= (nPhase >> 4)) {
				BLTVLINE(px);
			}
		}
		break;
		   }
	case 3:{	// cBltE16hbg
		for(int px=0;px<sx;px++){
			if ((15-(px & 15)) <= (nPhase >> 4)) {
				BLTVLINE(px);
			}
		}
		break;
		   }
	case 4:{	// Blt8hbg
		for(int py=0;py<sy;py++){
			if ((py & 7) <= (nPhase >> 5)) {
				BLTHLINE(py);
			}
		}
		break;
		   }
	case 5:{	// BltE8hbg
		for(int py=0;py<sy;py++){
			if ((7-(py & 7)) <= (nPhase >> 5)) {
				BLTHLINE(py);
			}
		}
		break;
		   }
	case 6:{	// Blt16hbg
		for(int py=0;py<sy;py++){
			if ((py & 15) <= (nPhase >> 4)) {
				BLTHLINE(py);
			}
		}
		break;
		   }
	case 7:{	// BltE16hbg
		for(int py=0;py<sy;py++){
			if ((15-(py & 15)) <= (nPhase >> 4)) {
				BLTHLINE(py);
			}
		}
		break;
		   }
	case 8:{	// E΂ߊBlt 8hbg
		int phase;
		phase = nPhase >> 5;
		for(int py=0;py<sy;py++){
			for(int px=-(py % 7);px<sx;px+=8){
				BLTHLINE2(py,px,phase);
			}
		}
		break;
		   }
	case 9:{	// E΂ߊBlt 16hbg
		int phase;
		phase = nPhase >> 4;
		for(int py=0;py<sy;py++){
			for(int px=-(py % 15);px<sx;px+=16){
				BLTHLINE2(py,px,phase);
			}
		}
		break;
		   }
	case 10:{	// `^ 4hbg
		int phase;
		phase = nPhase >> 6;
		for(int py=0;py<sy;py+=4){
			for(int px=0;px<sx;px+=4){
				BLTRECT(px,py,phase,phase);
			}
		}
		break;
		   }
	case 11:{	// `^ 8hbg
		int phase;
		phase = nPhase >> 5;
		for(int py=0;py<sy;py+=8){
			for(int px=0;px<sx;px+=8){
				BLTRECT(px,py,phase,phase);
			}
		}
		break;
		   }
	case 12:{	// `^ 16hbg
		int phase;
		phase = nPhase >> 4;
		for(int py=0;py<sy;py+=16){
			for(int px=0;px<sx;px+=16){
				BLTRECT(px,py,phase,phase);
			}
		}
		break;
		   }
	case 13:{	// ܂ O
		static int uzu[16] = {
			 0, 1, 2, 3,
			11,12,13, 4,
			10,15,14, 5,
			 9, 8, 7, 6
		};
		int phase;
		phase = nPhase >> 4;
		for(int py=0;py<sy;py++){
			for(int px=0;px<sx;px++){
				if (uzu[(px & 3)+((py & 3)<<2) & 15] <= phase){
					BLTPSET(px,py);
				}
			}
		}
		break;
		   }
	case 14:{	// ܂ 
		static int uzu[16] = {
			 6, 7, 8, 9,
			 5, 0, 1,10,
			 4, 3, 2,11,
			15,14,13,12
		};
		int phase;
		phase = nPhase >> 4;
		for(int py=0;py<sy;py++){
			for(int px=0;px<sx;px++){
				if (uzu[(px & 3)+((py & 3)<<2) & 15] <= phase){
					BLTPSET(px,py);
				}
			}
		}
		break;
		   }
	case 15:{	// gBlt
		for(int py=0;py<sy;py++){
			BLTHLINEOFFSET(py,(int) (blt_table.SinTable[(py+90)%360] * ((255-nPhase)*2)));
		}
		break;
		   }
	case 16:{	// gBlt 180ʑႢ
		for(int py=0;py<sy;py++){
			BLTHLINEOFFSET(py,(int) (blt_table.SinTable[(py+90+180)%360] * ((255-nPhase)*2)));
		}
		break;
		   }
	case 17:{	// gBlt
		for(int py=0;py<sy;py++){
			BLTHLINEOFFSET(py,(int) (blt_table.SinTable[((py+90)<<3)%360] * (255-nPhase)));
		}
		break;
		   }
	case 18:{	// gBlt 180ʑႢ
		for(int py=0;py<sy;py++){
			BLTHLINEOFFSET(py,(int) (blt_table.SinTable[(((py+90)<<3)+180)%360] * (255-nPhase)));
		}
		break;
		   }
	case 19:{	// Blend^
		EnableBlendColorKey(bltmode==1);
		BlendBlt(x,y,nPhase,nPhase,nPhase,256-nPhase,256-nPhase,256-nPhase);
		break;
		   }
	case 20:{	// _^ 4hbg`
		for(int py=0;py<sy;py+=4){
			for(int px=0;px<sx;px+=4){
				if (blt_table.RandTable[((px>>2) + (py>>2)*271) & 255] <= nPhase){
					BLTRECT(px,py,4,4);
				}
			}
		}
		break;
			}
	case 21:{	// _^ 8hbg`
		for(int py=0;py<sy;py+=8){
			for(int px=0;px<sx;px+=8){
				if (blt_table.RandTable[((px>>3) + (py>>3)*271) & 255] <= nPhase){
					BLTRECT(px,py,8,8);
				}
			}
		}
		break;
			}
	case 22:{	// _^ 16hbg`
		for(int py=0;py<sy;py+=16){
			for(int px=0;px<sx;px+=16){
				if (blt_table.RandTable[((px>>4) + (py>>4)*271) & 255] <= nPhase){
					BLTRECT(px,py,16,16);
				}
			}
		}
		break;
			}
	case 23:{	// _mCY
		for(int py=0;py<sy;py++){
			int r,r2;	//	ꕝ
			r2 = 256-nPhase;	//	ꕝ
			r = (rand() % r2) - (r2>>1);
			BLTHLINEOFFSET(py,r);
		}
		break;
		   }
	case 24:{	// h
		int level;
		if (nPhase<128) level = 10; else if (nPhase<200) level = 6;
		else if(nPhase<230) level = 4; else level = 2;
		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				if ((rand()%256) <= nPhase){
					BLTRECT(px,py,4,2);
				} else {
					BLTRECTNEIGHBOR(px,py,4,2,level);	//	ߏ̂Blt
				}
			}
		}
		break;
		   }
	case 25:{	// 
		double phase;
		phase = (double)(256-nPhase) / 256;
		for(int py=0;py<sy;py++){
			BLTHLINEST(py,1+2 * phase * blt_table.SinTable[180*py/sy]);
		}
		break;
		   }
	case 26:{	// c
		double phase;
		phase = (double)(256-nPhase) / 256;
		for(int px=0;px<sx;px++){
			BLTVLINEST(px,1+2 * phase * blt_table.SinTable[180*px/sx]);
		}
		break;
		   }
	case 27:{	// E~[
		for(int px=0;px<sx;px++){
			BLTVLINEFROM(px,sx-px-1);
		}
		break;
		   }
	case 28:{	// ㉺~[
		for(int py=0;py<sy;py++){
			BLTHLINEFROM(py,sy-py-1);
		}
		break;
		   }
	case 29:{	// Flush
		BLT();
		SwapToSecondary();	//	ZJ_̓]`tbV
		RECT rc;
		SetRect(&rc,x,y,x+sx,y+sy);
		FlushBlt(rc);
		SwapToSecondary();
		break;
		   }
	case 30:{	// Mosaic
		int phase;
		phase = ((255-nPhase)>>2) + 1;
		BLT();
		SwapToSecondary();	//	ZJ_̓]`ɃUCN
		RECT rc;
		SetRect(&rc,x,y,x+sx,y+sy);
		MosaicBlt(rc,phase);
		SwapToSecondary();
		break;
		   }
	case 31:{	// 4*2hbg` _tF[h
		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				if ((rand()&255) <= nPhase){
					BLTRECT(px,py,4,2);
				}
			}
		}
		break;
			}
	case 32:{	// 4*2hbg` _ tF[hォ
		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				if ((rand()&255) <= (nPhase<<1) + ((sy-py-1)<<8)/sy - 256){
					BLTRECT(px,py,4,2);
				}
			}
		}
		break;
			}
	case 33:{	// 4*2hbg` _ tF[h
		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				if ((rand()&255) <= (nPhase<<1) + (py<<8)/sy - 256){
					BLTRECT(px,py,4,2);
				}
			}
		}
		break;
			}
	case 34:{	// 4*2hbg` _ tF[h
		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				if ((rand()&255) <= (nPhase<<1) + ((sx-px-1)<<8)/sx - 256){
					BLTRECT(px,py,4,2);
				}
			}
		}
		break;
			}
	case 35:{	// 4*2hbg` _ tF[hE
		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				if ((rand()&255) <= (nPhase<<1) + (px<<8)/sx - 256){
					BLTRECT(px,py,4,2);
				}
			}
		}
		break;
			}
	case 36:{	// ܂ O 2*2
		static int uzu[16] = {
			 0, 1, 2, 3,
			11,12,13, 4,
			10,15,14, 5,
			 9, 8, 7, 6
		};
		int phase;
		phase = nPhase >> 4;
		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=2){
				if (uzu[((px>>1) & 3)+(((py>>1) & 3)<<2) & 15] <= phase){
					BLTRECT(px,py,2,2);
				}
			}
		}
		break;
		   }
	case 37:{	// ܂  2*2
		static int uzu[16] = {
			 6, 7, 8, 9,
			 5, 0, 1,10,
			 4, 3, 2,11,
			15,14,13,12
		};
		int phase;
		phase = nPhase >> 4;
		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=2){
				if (uzu[((px>>1) & 3)+(((py>>1) & 3)<<2) & 15] <= phase){
					BLTRECT(px,py,2,2);
				}
			}
		}
		break;
		   }
	case 38:{	// ܂ O 4*4
		static int uzu[16] = {
			 0, 1, 2, 3,
			11,12,13, 4,
			10,15,14, 5,
			 9, 8, 7, 6
		};
		int phase;
		phase = nPhase >> 4;
		for(int py=0;py<sy;py+=4){
			for(int px=0;px<sx;px+=4){
				if (uzu[((px>>2) & 3)+(((py>>2) & 3)<<2) & 15] <= phase){
					BLTRECT(px,py,4,4);
				}
			}
		}
		break;
		   }
	case 39:{	// ܂  4*4
		static int uzu[16] = {
			 6, 7, 8, 9,
			 5, 0, 1,10,
			 4, 3, 2,11,
			15,14,13,12
		};
		int phase;
		phase = nPhase >> 4;
		for(int py=0;py<sy;py+=4){
			for(int px=0;px<sx;px+=4){
				if (uzu[((px>>2) & 3)+(((py>>2) & 3)<<2) & 15] <= phase){
					BLTRECT(px,py,4,4);
				}
			}
		}
		break;
		   }
	case 40:{	// ܂ O 8*8
		static int uzu[16] = {
			 0, 1, 2, 3,
			11,12,13, 4,
			10,15,14, 5,
			 9, 8, 7, 6
		};
		int phase;
		phase = nPhase >> 4;
		for(int py=0;py<sy;py+=8){
			for(int px=0;px<sx;px+=8){
				if (uzu[((px>>3) & 3)+(((py>>3) & 3)<<2) & 15] <= phase){
					BLTRECT(px,py,8,8);
				}
			}
		}
		break;
		   }
	case 41:{	// ܂  8*8
		static int uzu[16] = {
			 6, 7, 8, 9,
			 5, 0, 1,10,
			 4, 3, 2,11,
			15,14,13,12
		};
		int phase;
		phase = nPhase >> 4;
		for(int py=0;py<sy;py+=8){
			for(int px=0;px<sx;px+=8){
				if (uzu[((px>>3) & 3)+(((py>>3) & 3)<<2) & 15] <= phase){
					BLTRECT(px,py,8,8);
				}
			}
		}
		break;
		   }
	case 42:{	// `
		int sm;	// max size
		if (sy>sx) sm=sy; else sm=sx;

		int sr;	// rest size
		sr = (sm * nPhase) >> 8;
		BLTRECT((sx>>1)-(sr>>1),(sy>>1)-(sr>>1),sr,sr);
		break;
		   }
	case 43:{	// ォ`
		int sm;	// max size
		if (sy>sx) sm=sy; else sm=sx;

		int sr;	// rest size
		sr = (sm * nPhase) >> 8;
		BLTRECT(0,0,sr,sr);
		break;
		   }
	case 44:{	// Eォ`
		int sm;	// max size
		if (sy>sx) sm=sy; else sm=sx;

		int sr;	// rest size
		sr = (sm * nPhase) >> 8;
		BLTRECT(sx-sr,0,sr,sr);
		break;
		   }
	case 45:{	// `
		int sm;	// max size
		if (sy>sx) sm=sy; else sm=sx;

		int sr;	// rest size
		sr = (sm * nPhase) >> 8;
		BLTRECT(0,sy-sr,sr,sr);
		break;
		   }
	case 46:{	// E`
		int sm;	// max size
		if (sy>sx) sm=sy; else sm=sx;

		int sr;	// rest size
		sr = (sm * nPhase) >> 8;
		BLTRECT(sx-sr,sy-sr,sr,sr);
		break;
		   }
	case 47:{	// ~
		int sm;	// max size
		sm = sx+sy;
		
		int sr;	// rest size
		sr = (sm * nPhase) >> 8;

		int ssy,py;
		ssy =-(sr >> 1);
		for(py=(sy>>1)-(sr>>1);py<((sy>>1)+(sr>>1));py++,ssy++){
			int px,rx;
			rx = sqrt(sr*sr/4-ssy*ssy)*2;
			px = (sx>>1)-(rx>>1);
			BLTRECT(px,py,rx,1); // NbvtHLINE
		}
		break;
		   }
	case 48:{	// EĂꂱŏo
		int sr;	// start size
		sr = (sx * nPhase) >> 8;
		for(int py=0;py<sy;py+=2){
			BLTRECT(0,py,sr,1); // NbvtHLINE
			BLTRECT(sx-sr-1,py+1,sx,1); // NbvtHLINE
		}
		break;
		   }
	case 49:{	// ㉺Ăꂱŏo
		int sr;	// start size
		sr = (sy * nPhase) >> 8;
		for(int px=0;px<sx;px+=2){
			BLTRECT(px,0,1,sr); // NbvtVLINE
			BLTRECT(px+1,sy-sr-1,1,sy); // NbvtVLINE
		}
		break;
		   }
	case 50:{	// EĂꂱQiŏo
		int sr;	// start size
		sr = (sx * nPhase) >> 7;
		for(int py=0;py<sy;py+=4){
			BLTRECT(0,py,sr,1);			// NbvtHLINE
			BLTRECT(sx-sr-1,py+2,sx,1);	// NbvtHLINE
		}
		if (nPhase > 128) {
			for(int py=0;py<sy;py+=4){
				sr = (sx * (nPhase-128)) >> 7;
				BLTRECT(0,py+1,sr,1);		// NbvtHLINE
				BLTRECT(sx-sr-1,py+3,sx,1); // NbvtHLINE
			}
		}
		break;
		   }
	case 51:{	// ㉺ĂꂱQiŏo
		int sr;	// start size
		sr = (sy * nPhase) >> 7;
		for(int px=0;px<sx;px+=4){
			BLTRECT(px,0,1,sr);			// NbvtVLINE
			BLTRECT(px+2,sy-sr-1,1,sy);	// NbvtVLINE
		}
		if (nPhase > 128) {
			for(int px=0;px<sx;px+=4){
				sr = (sy * (nPhase-128)) >> 7;
				BLTRECT(px+1,0,1,sr);		// NbvtVLINE
				BLTRECT(px+3,sy-sr-1,1,sy); // NbvtVLINE
			}
		}
		break;
		   }
	case 52:{	// 烉_tF[h 4*2`
		int sm;	// max size
		sm = sx+sy;
		
		int sr;	// rest size
		sr = (sm * nPhase) >> 8;

		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				if ((rand()&255) <=
					sr-sqrt((px*2-sx)*(px*2-sx)+(py*2-sy)*(py*2-sy)))
				{
					BLTRECT(px,py,4,2);
				}
			}
		}

		break;
		   }
	case 53:{	// 烉_tF[h 2*2`
		int sm;	// max size
		sm = sx+sy;
		
		int sr;	// rest size
		sr = (sm * nPhase) >> 8;

		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=2){
				if ((rand()&255) <=
					sr-sqrt((px*2-sx)*(px*2-sx)+(py*2-sy)*(py*2-sy)))
				{
					BLTRECT(px,py,2,2);
				}
			}
		}

		break;
		   }
	case 54:{	// VbtOォ牺
		int sr;	// rest size
		sr = (sy * nPhase) >> 8;

		BLTRECT(0,0,sx,sr);
		BLTHLINEOFFSET(sr,-sx/9);
		BLTHLINEOFFSET(sr+1,sx/9);
		BLTHLINEOFFSET(sr+2,-sx*2/9);
		BLTHLINEOFFSET(sr+3,sx*2/9);
		BLTHLINEOFFSET(sr+4,-sx/3);
		BLTHLINEOFFSET(sr+5,sx/3);
		break;
		   }
	case 55:{	// VbtO
		int sr;	// rest size
		sr = sy - ((sy * nPhase) >> 8);

		BLTRECT(0,sr,sx,sy-sr);
		BLTHLINEOFFSET(sr-1,-sx/9);
		BLTHLINEOFFSET(sr-2,sx/9);
		BLTHLINEOFFSET(sr-3,-sx*2/9);
		BLTHLINEOFFSET(sr-4,sx*2/9);
		BLTHLINEOFFSET(sr-5,-sx/3);
		BLTHLINEOFFSET(sr-6,sx/3);
		break;
		   }
	case 56:{	// ΂ߊgU
		int sm;	// max size
		sm = sx+sy;
		int sr;	// rest size
		sr = sm - ((sm * nPhase) >> 8);

		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				BLTRECTOFFSET(px,py,4,2,(sr*blt_table.RandTable[(px+py)&0xff])>>8,(sr*blt_table.RandTable[(px+py+1)&0xff])>>8);
			}
		}

		break;
		   }
	case 57:{	// _gȔW 4*2
		int sm;	// max size
		sm = sx+sy;
		int sr;	// rest size
		sr = sm - ((sm * nPhase) >> 8);

		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				int ex,ey;	//	摜SsNZ̕PʃxNg*256{
				ex = px - sx/2;
				ey = py - sy/2;
				int r;
				r = sqrt(ex*ex + ey*ey);
				if (r!=0) {
					ex = (ex<<8) / r;
					ey = (ey<<8) / r;
				}
				BLTRECTOFFSET(px,py,4,2,(sr*ex*blt_table.RandTable[(px+py*13)&0xff])>>16,(sr*ey*blt_table.RandTable[(px+py*19+1)&0xff])>>16);
			}
		}

		break;
		   }
	case 58:{	// _gȔW 2*2
		int sm;	// max size
		sm = sx+sy;
		int sr;	// rest size
		sr = sm - ((sm * nPhase) >> 8);

		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=2){
				int ex,ey;	//	摜SsNZ̕PʃxNg*256{
				ex = px - sx/2;
				ey = py - sy/2;
				int r;
				r = sqrt(ex*ex + ey*ey);
				if (r!=0) {
					ex = (ex<<8) / r;
					ey = (ey<<8) / r;
				}
				BLTRECTOFFSET(px,py,2,2,(sr*ex*blt_table.RandTable[(px+py*13)&0xff])>>16,(sr*ey*blt_table.RandTable[(px+py*19+1)&0xff])>>16);
			}
		}

		break;
		   }
	case 59:{	// _gȔW
		int sm;	// max size
		sm = sx+sy;
		int sr;	// rest size
		sr = sm - ((sm * nPhase) >> 8);

		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				int ex,ey;	//	摜SsNZ̕PʃxNg*256{
				ex = px - sx/2;
				ey = py - sy/2;
				int r;
				r = sqrt(ex*ex + ey*ey);
				if (r!=0) {
					ex = (ex<<8) / r;
					ey = (ey<<8) / r;
				}
				BLTRECTOFFSET(px,py,4,2,((sr*ex*blt_table.RandTable[(px+py*13)&0xff])>>16)*blt_table.SinTable[90+256-nPhase]
					,((sr*ey*blt_table.RandTable[(px+py*19+1)&0xff])>>16)*blt_table.SinTable[256-nPhase]);
			}
		}
		break;
			}
	case 60:{	// Ԃ
		int sm;	// max size
		sm = sx+sy;
		int sr;	// rest size
		sr = sm - ((sm * nPhase) >> 8);

		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				int ex,ey;	//	摜SsNZ̕PʃxNg*256{
				ex = px - sx/2;
				ey = py - sy/2;
				int r;
				r = sqrt(ex*ex + ey*ey);
				if (r!=0) {
					ex = (ex<<8)*blt_table.SinTable[256-(nPhase >> 4)] / r;
					ey = (ey<<8)*blt_table.SinTable[90+256-(nPhase >> 4)] / r;
				}
				BLTRECTOFFSET(px,py,4,2,(sr*ex) >> 8,(sr*ey) >> 8);
			}
		}
		break;
		   }
	case 61:{	// O]
		int sm;	// max size
		sm = sx+sy;
		int sr;	// rest size
		sr = sm - ((sm * nPhase) >> 8);

		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=4){
				int ex,ey;	//	摜SsNZ̕PʃxNg*256{
				ex = px - sx/2;
				ey = py - sy/2;
				ex *= blt_table.SinTable[90+256-(nPhase >> 4)];
				ey *= blt_table.SinTable[256-(nPhase >> 4)];
				BLTRECTOFFSET(px,py,4,2,(sr*ex) >> 8,(sr*ey) >> 8);
			}
		}
		break;
		   }
	case 62:{	// ʒS]
		int sm;	// max size
		sm = sx+sy;
		int sr;	// rest size
		sr = sm - ((sm * nPhase) >> 8);

		for(int py=0;py<sy;py+=2){
			for(int px=0;px<sx;px+=2){
				int ex,ey,ex2,ey2;	//	摜SsNZ̕PʃxNg*256{
				ex = px - sx/2;
				ey = py - sy/2;
				int ph;
				ph = (256-nPhase)*360 >> 8;
				ex2 = ex * blt_table.SinTable[(90+ph) % 360]	- ey * blt_table.SinTable[ph % 360];
				ey2 = ex * blt_table.SinTable[ph % 360]			+ ey * blt_table.SinTable[(90+ph) % 360];
				BLTRECTOFFSET(px,py,2,2,-ex + ex2,-ey + ey2);
			}
		}
		break;
			}
	case 63:{	// ʒS]
		int sm;	// max size
		sm = sx+sy;
		int sr;	// rest size
		sr = sm - ((sm * nPhase) >> 8);

		for(int py=0;py<sy;py+=4){
			for(int px=0;px<sx;px+=4){
				int ex,ey,ex2,ey2;	//	摜SsNZ̕PʃxNg*256{
				ex = px - sx/2;
				ey = py - sy/2;
				int ph;
				ph = (256-nPhase)*360 >> 8;
				ex2 = ex * blt_table.SinTable[(90+ph) % 360]	- ey * blt_table.SinTable[ph % 360];
				ey2 = ex * blt_table.SinTable[ph % 360]			+ ey * blt_table.SinTable[(90+ph) % 360];
				BLTRECTOFFSET(px,py,4,4,-ex + ex2,-ey + ey2);
			}
		}
		break;
		   }
	case 64:{	// ʒS]
		int sm;	// max size
		sm = sx+sy;
		int sr;	// rest size
		sr = sm - ((sm * nPhase) >> 8);

		for(int py=0;py<sy;py+=8){
			for(int px=0;px<sx;px+=8){
				int ex,ey,ex2,ey2;	//	摜SsNZ̕PʃxNg*256{
				ex = px - sx/2;
				ey = py - sy/2;
				int ph;
				ph = (256-nPhase)*360 >> 8;
				ex2 = ex * blt_table.SinTable[(90+ph) % 360]	- ey * blt_table.SinTable[ph % 360];
				ey2 = ex * blt_table.SinTable[ph % 360]			+ ey * blt_table.SinTable[(90+ph) % 360];
				BLTRECTOFFSET(px,py,8,8,-ex + ex2,-ey + ey2);
			}
		}
		break;
			}
	case 65:{	// ʒS]
		int sm;	// max size
		sm = sx+sy;
		int sr;	// rest size
		sr = sm - ((sm * nPhase) >> 8);

		for(int py=0;py<sy;py+=4){
			for(int px=0;px<sx;px+=4){
				int ex,ey,ex2,ey2;	//	摜SsNZ̕PʃxNg*256{
				ex = px - sx/2;
				ey = py - sy/2;
				int ph;
				ph = (256-nPhase)*360 >> 8;
				ex2 = ex * blt_table.SinTable[(90+ph) % 360]	- ey * blt_table.SinTable[ph % 360];
				ey2 = ex * blt_table.SinTable[ph % 360]			+ ey * blt_table.SinTable[(90+ph) % 360];
				int r;
				r = sqrt(ex*ex + ey*ey);
				if (r!=0) {
					ex = (ex<<8) / r;
					ey = (ey<<8) / r;
				}
				BLTRECTOFFSET(px,py,4,4,-ex + ex2 + ((sr*ex*blt_table.RandTable[(px+py*13)&0xff])>>16)*blt_table.SinTable[90+256-nPhase]
					,-ey + ey2 + ((sr*ey*blt_table.RandTable[(px+py*19+1)&0xff])>>16)*blt_table.SinTable[256-nPhase]);
			}
		}
		break;
		   }
	case 66:{	// 8*8 In
		for(int py=0;py<sy;py+=8){
			for(int px=0;px<sx;px+=8){
				int hy;
				hy = (nPhase + (blt_table.RandTable[((px>>3)+py*13)&255] >> 1))>>4;
				hy -= 8;
				if (hy>0) {
					if (hy>8) hy = 8;
					BLTRECTOFFSET(px,py,8,hy,0,8-hy);
				}
			}
		}
		break;
		   }
	case 67:{	// 16*16 In
		for(int py=0;py<sy;py+=16){
			for(int px=0;px<sx;px+=16){
				int hy;
				hy = (nPhase + (blt_table.RandTable[((px>>3)+py*13)&255] >> 1))>>3;
				hy -= 16;
				if (hy>0) {
					if (hy>16) hy = 16;
					BLTRECTOFFSET(px,py,16,hy,0,16-hy);
				}
			}
		}
		break;
		   }
	case 68:{	// ݂

		int ph;
		ph = (nPhase >> 1) + 1;
		for(int py=0;py<sy;py+=4){
			for(int px=0;px<sx;px+=4){
				int oox,ooy;
				oox = blt_table.RandTable[((px>>2)+(py>>2)*13)&255] - 128;
				ooy = blt_table.RandTable[((px>>2)+(py>>2)*19)&255] - 128;
				oox = oox / ph;
				ooy = ooy / ph;
				BLTRECTOFFSET(px,py,4,4,oox,ooy);
			}
		}

		break;
		   }
	case 69:{	// ݂݂Q

		int ph;
		ph = 256-nPhase;
		for(int py=0;py<sy;py+=4){
			for(int px=0;px<sx;px+=4){
				int oox,ooy;
				oox = blt_table.RandTable[((px>>2)+(py>>2)*13)&255] - 128;
				ooy = blt_table.RandTable[((px>>2)+(py>>2)*19)&255];
				oox = oox * ph >> 11;
				ooy = ooy * ph >> 11;
				BLTRECTOFFSET(px,py,4,4,oox,ooy);
			}
		}

		break;
		   }
	case 70:{	// ォ~
		int sm;	// max size
		sm = sqrt(sx*sx/4+sy*sy)*2;
		
		int sr;	// rest size
		sr = (sm * nPhase) >> 8;

		int ssy,py;
		ssy = 0;
//		ssy =-(sr >> 1);
		for(py=0;py<(sr>>1);py++,ssy++){
//		for(py=(sy>>1)-(sr>>1);py<((sy>>1)+(sr>>1));py++,ssy++){
			int px,rx;
			rx = sqrt(sr*sr/4-ssy*ssy)*2;
			px = (sx>>1)-(rx>>1);
			BLTRECT(px,py,rx,1); // NbvtHLINE
		}
		break;
		   }
	case 71:{	// ~
		int sm;	// max size
		sm = sqrt(sx*sx/4+sy*sy)*2;
		
		int sr;	// rest size
		sr = (sm * nPhase) >> 8;

		int ssy,py;
		ssy = 0;
//		ssy =-(sr >> 1);
		for(py=sy;py>sy-(sr>>1);py--,ssy++){
//		for(py=(sy>>1)-(sr>>1);py<((sy>>1)+(sr>>1));py++,ssy++){
			int px,rx;
			rx = sqrt(sr*sr/4-ssy*ssy)*2;
			px = (sx>>1)-(rx>>1);
			BLTRECT(px,py,rx,1); // NbvtHLINE
		}
		break;
		   }
	case 72:{	// ~
		int sm;	// max size
		sm = sqrt(sx*sx+sy*sy/4)*2;
		
		int sr;	// rest size
		sr = (sm * nPhase) >> 8;

		int ssy,py;
		ssy =-(sr >> 1);
		for(py=(sy>>1)-(sr>>1);py<((sy>>1)+(sr>>1));py++,ssy++){
//		for(py=(sy>>1)-(sr>>1);py<((sy>>1)+(sr>>1));py++,ssy++){
			int px,rx;
			rx = sqrt(sr*sr/4-ssy*ssy);
//			px = (sx>>1)-(rx>>1);
			px = 0;
			BLTRECT(px,py,rx,1); // NbvtHLINE
		}
		break;
		   }
	case 73:{	// E~
		int sm;	// max size
		sm = sqrt(sx*sx+sy*sy/4)*2;
		
		int sr;	// rest size
		sr = (sm * nPhase) >> 8;

		int ssy,py;
		ssy =-(sr >> 1);
		for(py=(sy>>1)-(sr>>1);py<((sy>>1)+(sr>>1));py++,ssy++){
//		for(py=(sy>>1)-(sr>>1);py<((sy>>1)+(sr>>1));py++,ssy++){
			int px,rx;
			rx = sqrt(sr*sr/4-ssy*ssy);
//			px = (sx>>1)-(rx>>1);
			px = sx-rx;
			BLTRECT(px,py,rx,1); // NbvtHLINE
		}
		break;
		   }
	default:
		return 1; // not supported!!
	}
	return 0;
}
