// yaneWindow.cpp
#include "yaneWindow.h"
#include "yaneWinHook.h"
#include "yaneError.h"

CGameWindow::CGameWindow(void){
	m_nBackColor=0;			  // NfBtHg
	m_hWnd	   =NULL;
	m_WindowStyle = WS_VISIBLE|WS_SYSMENU|WS_CAPTION|WS_MAXIMIZEBOX|WS_MINIMIZEBOX;
	m_nXPos = m_nYPos = CW_USEDEFAULT;
}

CGameWindow::~CGameWindow(){

}

HWND CGameWindow::InitWindow(HINSTANCE hInst,string Caption,EScreenMode ScrMode,int nXSize,int nYSize) {
	// ܂́AEBhD𐶐
	// XN[Z[o[ɂΉȂĂ...

	// ܂̃EChENX
	WNDCLASS wndclass;
	wndclass.style		   = CS_DBLCLKS;
	wndclass.lpfnWndProc   = CWinHook::WindowProc;
	wndclass.cbClsExtra	   = 0;
	wndclass.cbWndExtra	   = 0;
	wndclass.hInstance	   = hInst;
	
	wndclass.hIcon		   = LoadIcon(hInst,"MAIN");
	// Ƃ肠AACR\

	wndclass.hCursor	   = LoadCursor(NULL,IDC_ARROW);
	// Ƃ肠A}EXJ[\pӁisvȂ΁AƂŏׂIj

	// obNJ[́AƍT|[g΂DDD
	// AŐݒ肷̂́A܂ӖƂ͎vȂ
	switch (m_nBackColor) {
	case 0 : {
		wndclass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
		m_dwFillColor = 0;	// ZJ_obt@̓hԂF
		break;
	}
	case 1 : {
		 wndclass.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
		 m_dwFillColor = 0xFFFFFFFF;	 // ZJ_obt@̓hԂF
		 break;
	}
	default :
		 wndclass.hbrBackground = (HBRUSH)GetStockObject(GRAY_BRUSH);
		 m_dwFillColor = 0x80808080;	 // ZJ_obt@̓hԂF
		 // ȂDF (for debug)
	}

	wndclass.lpszMenuName  = NULL;
	wndclass.lpszClassName = Caption.c_str();

	// ȂŎsĂ񂾂ˁH
	if (!RegisterClass(&wndclass)) {
		InnerLog("CGameWindow::CreateWindow()RegisterClasss");
		return NULL;
	}

	switch (ScrMode){
	case FullScreenMode: {
		// EChE̐itXN[j
		m_hWnd = CreateWindow(Caption.c_str(),Caption.c_str(),
						WS_POPUP|WS_VISIBLE /* |WS_SYSMENU|
						WS_MAXIMIZEBOX|WS_MINIMIZEBOX */ ,
						0, 0, 
						GetSystemMetrics(SM_CXSCREEN), // 640*480?
						GetSystemMetrics(SM_CYSCREEN), // Ƃ킯łȂ
						NULL, NULL, hInst, NULL );
						}
	break;
	case WindowMode: {
		// Ƃ肠Aʂ̂܂ȂɏoƂB

		// EBhDElɓȂĂ͂ȂȂ
		// \͈͂640*480Ȃ΁AׂWindowTCÝAȏł
		RECT r;
		SetRect(&r,0,0,nXSize,nYSize);
		AdjustWindowRect(&r,m_WindowStyle,false);

		m_hWnd = CreateWindow(Caption.c_str(),Caption.c_str(), // WS_EX_TOPMOSTw肵񂾂ǂȁ[
						m_WindowStyle,
						m_nXPos,
						m_nYPos,
						r.left,r.bottom,
						NULL, NULL, hInst, NULL );

		::SetWindowPos(m_hWnd,NULL,
				r.left,r.top,r.right-r.left,r.bottom-r.top,
				SWP_NOZORDER|SWP_NOMOVE);
		//	EBhDTCY𑬍Uf邽߂ɂ́AꂪKvB

					 }
		break;
	}
	if (m_hWnd==NULL){
		InnerLog("CGameWindowCreateWindowɎsB");
		return NULL;
	}

	ShowWindow(m_hWnd, SW_SHOW);
	return m_hWnd;
}

void CGameWindow::SetBackColor(int nBackColor){
	m_nBackColor = nBackColor;
}

DWORD CGameWindow::GetFillColor(void){	// DirectDraw̓hԂF̎擾
	return m_dwFillColor;
}

HWND CGameWindow::GetHWnd(void){
	return m_hWnd;
}

void CGameWindow::GetScreenSize(int &x,int &y){
	x = ::GetSystemMetrics(SM_CXSCREEN);
	y = ::GetSystemMetrics(SM_CYSCREEN);
}

LRESULT CGameWindow::SetWindowPos(int x,int y){
	m_nXPos = x;
	m_nYPos = y;
	if (m_hWnd==NULL) return 0;
	//	EBhEĂړȂĂ͂ȂȂ
	return !::SetWindowPos(m_hWnd,NULL,m_nXPos,m_nYPos,NULL,NULL,SWP_NOSIZE|SWP_NOZORDER);
}